/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.electric;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import com.Da_Technomancer.essentials.tileentities.ILinkTE;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TeslaCoilTop
extends ContainerBlock {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)TeslaCoilTop.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)TeslaCoilTop.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    public final TeslaCoilVariants variant;

    public TeslaCoilTop(TeslaCoilVariants variant) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.0f));
        this.variant = variant;
        String name = "tesla_coil_top_" + variant.toString();
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (ILinkTE.isLinkTool((ItemStack)heldItem)) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (!worldIn.field_72995_K && te instanceof TeslaCoilTopTileEntity) {
                ((TeslaCoilTopTileEntity)te).wrench(heldItem, playerIn);
            }
            return true;
        }
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.range", new Object[]{this.variant.range}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.fe", new Object[]{this.variant.joltAmt}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.eff", new Object[]{100 - this.variant.efficiency}));
        if (this.variant == TeslaCoilVariants.ATTACK) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.att", new Object[0]));
        } else if (this.variant == TeslaCoilVariants.DECORATIVE) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.decor", new Object[0]));
        }
        if (this.variant.joltAmt > 2000) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_coil_top.leyden", new Object[0]));
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TeslaCoilTopTileEntity();
    }

    public static enum TeslaCoilVariants {
        NORMAL(1000, 8, 98),
        ATTACK(1000, 6, 0),
        DISTANCE(1000, 32, 98),
        INTENSITY(10000, 8, 98),
        EFFICIENCY(1000, 8, 100),
        DECORATIVE(100, 0, 0);

        public final int joltAmt;
        public final int range;
        public final int efficiency;

        private TeslaCoilVariants(int joltAmt, int range, int efficiency) {
            this.joltAmt = joltAmt;
            this.range = range;
            this.efficiency = efficiency;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

