/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.blocks.rotary;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.rotary.RotaryDrillTileEntity;
import com.Da_Technomancer.essentials.ESConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RotaryDrill
extends ContainerBlock {
    private static final VoxelShape[] SHAPES = new VoxelShape[6];
    private final boolean golden;

    public RotaryDrill(boolean golden) {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).func_200947_a(SoundType.field_185852_e));
        this.golden = golden;
        String name = "rotary_drill" + (golden ? "_gold" : "");
        this.setRegistryName(name);
        CRBlocks.toRegister.add((Block)this);
        CRBlocks.blockAddQue(this);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new RotaryDrillTileEntity(this.golden);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)ESProperties.FACING, (Comparable)context.func_196010_d());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b((IProperty)ESProperties.FACING)).func_176745_a()];
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (ESConfig.isWrench((ItemStack)playerIn.func_184586_b(hand))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (BlockState)state.func_177231_a((IProperty)ESProperties.FACING));
            }
            return true;
        }
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ESProperties.FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (this.golden) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.drill.desc.gold", new Object[0]));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.drill.desc", new Object[0]));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.drill.power", new Object[]{2.0}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.inertia", new Object[]{RotaryDrillTileEntity.INERTIA[this.golden ? 1 : 0]}));
        tooltip.add(new TranslationTextComponent("tt.crossroads.drill.quip", new Object[0]).func_150255_a(MiscUtil.TT_QUIP));
    }

    static {
        RotaryDrill.SHAPES[0] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), RotaryDrill.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0)});
        RotaryDrill.SHAPES[1] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), RotaryDrill.func_208617_a((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
        RotaryDrill.SHAPES[2] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0), RotaryDrill.func_208617_a((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0)});
        RotaryDrill.SHAPES[3] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)6.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0), RotaryDrill.func_208617_a((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0)});
        RotaryDrill.SHAPES[4] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)10.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)4.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0), RotaryDrill.func_208617_a((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0)});
        RotaryDrill.SHAPES[5] = VoxelShapes.func_216384_a((VoxelShape)RotaryDrill.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{RotaryDrill.func_208617_a((double)6.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0), RotaryDrill.func_208617_a((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0)});
    }
}

