/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.entity;

import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.EnumReagents;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentStack;
import com.Da_Technomancer.crossroads.API.effects.alchemy.IAlchEffect;
import com.Da_Technomancer.crossroads.CRConfig;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class EntityFlameCore
extends Entity {
    @ObjectHolder(value="flame_core")
    public static EntityType<EntityFlameCore> type = null;
    protected static final DataParameter<Integer> TIME_EXISTED = EntityDataManager.func_187226_a(EntityFlameCore.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityFlameCore.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final float FLAME_VEL = 0.1f;
    private ArrayList<ReagentStack> reagList = new ArrayList();
    private Color col;
    private int ticksExisted = -1;
    private int maxRadius;
    private ReagentMap reags = null;

    public EntityFlameCore(EntityType<EntityFlameCore> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70145_X = true;
        this.field_70158_ak = true;
    }

    public void setInitialValues(ReagentMap reags, int radius) {
        this.reags = reags == null ? new ReagentMap() : reags;
        this.maxRadius = radius;
    }

    public AxisAlignedBB func_184177_bl() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(TIME_EXISTED, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)Color.WHITE.getRGB());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.reags = new ReagentMap();
        this.maxRadius = nbt.func_74762_e("rad");
        this.reags = ReagentMap.readFromNBT(nbt);
        this.setInitialValues(this.reags, this.maxRadius);
        this.ticksExisted = nbt.func_74762_e("life");
        this.field_70180_af.func_187227_b(TIME_EXISTED, (Object)this.ticksExisted);
        if (nbt.func_74764_b("color")) {
            this.col = new Color(nbt.func_74762_e("color"), true);
            this.field_70180_af.func_187227_b(COLOR, (Object)this.col.getRGB());
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.reags != null) {
            this.reags.write(nbt);
        }
        if (this.col != null) {
            nbt.func_74768_a("color", this.col.getRGB());
        }
        nbt.func_74768_a("rad", this.maxRadius);
        nbt.func_74768_a("life", this.ticksExisted);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K || this.reags == null) {
            return;
        }
        ++this.ticksExisted;
        this.field_70180_af.func_187227_b(TIME_EXISTED, (Object)this.ticksExisted);
        if (this.col == null) {
            this.reagList.clear();
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 0;
            int amount = 0;
            double temp = this.reags.getTempC();
            for (IReagent type : this.reags.keySet()) {
                int qty = this.reags.getQty(type);
                if (qty <= 0) continue;
                Color color = type.getColor(type.getPhase(temp));
                r += qty * color.getRed();
                g += qty * color.getGreen();
                b += qty * color.getBlue();
                a += qty * color.getAlpha();
                amount += qty;
                if (type.getId().equals(EnumReagents.PHELOSTOGEN.id()) || type.getId().equals(EnumReagents.HELLFIRE.id())) continue;
                this.reagList.add(this.reags.getStack(type));
            }
            if (amount <= 0) {
                this.func_70106_y();
                return;
            }
            this.col = new Color(r / amount, g / amount, b / amount, a / amount);
            this.field_70180_af.func_187227_b(COLOR, (Object)this.col.getRGB());
        }
        if (this.ticksExisted % 8 == 0) {
            int radius = Math.round(0.1f * (float)this.ticksExisted);
            BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            boolean lastAction = this.maxRadius <= radius;
            double temp = this.reags.getTempC();
            for (int i = 0; i <= radius; ++i) {
                for (int j = 0; j <= radius; ++j) {
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, -radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, -radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, -radius, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, -radius, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, radius, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, radius, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, j, -radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, j, -radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, j - radius, -radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, j - radius, -radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, j, radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, j, radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i, j - radius, radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(i - radius, j - radius, radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(-radius, i, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(-radius, i - radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(-radius, i, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(-radius, i - radius, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(radius, i, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(radius, i - radius, j), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(radius, i, j - radius), lastAction);
                    EntityFlameCore.act(this.reagList, this.reags, temp, this.field_70170_p, pos.func_177982_a(radius, i - radius, j - radius), lastAction);
                }
            }
            if (lastAction) {
                this.func_70106_y();
            }
        }
    }

    private static void act(ArrayList<ReagentStack> reagList, ReagentMap reags, double temp, World world, BlockPos pos, boolean lastAction) {
        BlockState state;
        if (reags.getQty(EnumReagents.ALCHEMICAL_SALT.id()) == 0 && !CRConfig.isProtected(world, pos, state = world.func_180495_p(pos)) && state.func_185887_b((IBlockReader)world, pos) >= 0.0f) {
            world.func_180501_a(pos, lastAction && Math.random() > 0.75 && Blocks.field_150480_ab.func_176223_P().func_196955_c((IWorldReader)world, pos) ? Blocks.field_150480_ab.func_176223_P() : Blocks.field_150350_a.func_176223_P(), lastAction ? 3 : 18);
        }
        for (ReagentStack r : reagList) {
            IAlchEffect effect;
            if (r == null || (effect = r.getType().getEffect()) == null) continue;
            effect.doEffect(world, pos, r.getAmount(), EnumMatterPhase.FLAME, reags);
        }
    }

    public boolean func_70041_e_() {
        return false;
    }
}

