/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.entity;

import com.Da_Technomancer.crossroads.Crossroads;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class EntityGhostMarker
extends Entity {
    @ObjectHolder(value="ghost_marker")
    private static EntityType<EntityGhostMarker> type = null;
    private long time;
    private int lifespan;
    private EnumMarkerType markType;
    public CompoundNBT data;

    public EntityGhostMarker(EntityType<EntityGhostMarker> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70145_X = true;
    }

    public EntityGhostMarker(World worldIn, @Nonnull EnumMarkerType markerType) {
        this(worldIn, markerType, markerType.defaultLifespan);
    }

    public EntityGhostMarker(World worldIn, @Nonnull EnumMarkerType markerType, int lifespan) {
        super(type, worldIn);
        this.markType = markerType;
        this.lifespan = lifespan;
        this.time = worldIn.func_82737_E();
        this.func_189654_d(true);
        this.field_70145_X = true;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        nbt.func_74778_a("type", this.markType.name());
        nbt.func_74768_a("life", this.lifespan);
        nbt.func_74772_a("time", this.time);
        if (this.data != null) {
            nbt.func_218657_a("data", (INBT)this.data);
        }
    }

    @Nullable
    public EnumMarkerType getMarkerType() {
        return this.markType;
    }

    protected void func_213281_b(CompoundNBT nbt) {
        try {
            this.markType = EnumMarkerType.valueOf(nbt.func_74779_i("type"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Crossroads.logger.error("Failed to load EntityGhostMarker at " + this.func_180425_c().toString() + "; dim: " + this.field_70170_p.func_201675_m().func_186058_p().func_186068_a() + "; with type: " + nbt.func_74779_i("type") + ". Removing.");
            this.func_70106_y();
        }
        this.lifespan = nbt.func_74762_e("life");
        this.time = nbt.func_74763_f("time");
        if (nbt.func_74764_b("data")) {
            this.data = nbt.func_74775_l("data");
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.lifespan >= 0 && this.time != this.field_70170_p.func_82737_E()) {
            this.time = this.field_70170_p.func_82737_E();
            if (--this.lifespan == 0) {
                if (this.markType != null && this.markType.expireEffect != null) {
                    this.markType.expireEffect.accept(this);
                }
                this.func_70106_y();
            }
        }
    }

    public static enum EnumMarkerType {
        EQUILIBRIUM(5, null),
        VOID_EQUILIBRIUM(5, null),
        DELAYED_EXPLOSION(4, marker -> {
            if (marker.data != null && marker.data.func_74764_b("power")) {
                marker.field_70170_p.func_217398_a((Entity)marker, marker.field_70165_t, marker.field_70163_u, marker.field_70161_v, marker.data.func_74760_g("power"), marker.data.func_74767_n("flaming"), Explosion.Mode.valueOf((String)marker.data.func_74779_i("blast_type")));
            }
        }),
        BLOCK_SPAWNING(5, null);

        private final int defaultLifespan;
        private final Consumer<EntityGhostMarker> expireEffect;

        private EnumMarkerType(int defaultLifespan, Consumer<EntityGhostMarker> expireEffect) {
            this.defaultLifespan = defaultLifespan;
            this.expireEffect = expireEffect;
        }
    }
}

