/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BeamTransmuteRec;
import com.google.common.collect.ImmutableList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class BeamTransmuteCategory
implements IRecipeCategory<BeamTransmuteRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "transmute_beam");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawable arrowStatic;
    private final IDrawable icon;

    protected BeamTransmuteCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 80);
        this.slot = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.beamReflector, 1));
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends BeamTransmuteRec> getRecipeClass() {
        return BeamTransmuteRec.class;
    }

    public String getTitle() {
        return "Beam Transmutation";
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BeamTransmuteRec recipe, double mouseX, double mouseY) {
        this.slot.draw(40, 40);
        this.slot.draw(120, 40);
        this.arrowStatic.draw(78, 40);
        Minecraft.func_71410_x().field_71466_p.func_211126_b(MiscUtil.localize("crossroads.jei.beam_trans.align", recipe.getAlign().getLocalName(recipe.isVoid())), 50.0f, 10.0f, 0x404040);
        Minecraft.func_71410_x().field_71466_p.func_211126_b(MiscUtil.localize("crossroads.jei.beam_trans.power", recipe.getPower()), 50.0f, 70.0f, 0x404040);
    }

    public void setRecipe(IRecipeLayout recipeLayout, BeamTransmuteRec recipe, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 40, 40);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, false, 120, 40);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
    }

    public void setIngredients(BeamTransmuteRec recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, (List)ImmutableList.of(recipe.getIngr().getMatchedItemForm()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }
}

