/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CrucibleRec;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class HeatingCrucibleCategory
implements IRecipeCategory<CrucibleRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "heating_crucible");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawable icon;
    private final IDrawable arrowStatic;
    private final IDrawable fluidOverlay;

    protected HeatingCrucibleCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.heatingCrucible, 1));
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CrucibleRec> getRecipeClass() {
        return CrucibleRec.class;
    }

    public String getTitle() {
        return CRBlocks.heatingCrucible.func_200291_n().func_150254_d();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public void draw(CrucibleRec recipe, double mouseX, double mouseY) {
        Minecraft.func_71410_x().field_71466_p.func_211126_b("When above 1000\u00b0C", 10.0f, 10.0f, 0x404040);
        Minecraft.func_71410_x().field_71466_p.func_211126_b(String.format("Total Heat Consumed: %1$d\u00b0C", 1000), 10.0f, 20.0f, 0x404040);
        this.slot.draw(40, 50);
        this.arrowStatic.draw(62, 50);
        this.arrow.draw(62, 50);
    }

    public void setRecipe(IRecipeLayout layout, CrucibleRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = layout.getItemStacks();
        IGuiFluidStackGroup fluidGroup = layout.getFluidStacks();
        fluidGroup.init(0, false, 90, 30, 16, 64, 2000, true, this.fluidOverlay);
        fluidGroup.set(0, recipe.getOutput());
        itemGroup.init(0, true, 40, 50);
        itemGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CrucibleRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutput());
    }
}

