/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCore;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.gui.container.DetailedCrafterContainer;
import com.Da_Technomancer.crossroads.integration.JEI.AlchemyCategory;
import com.Da_Technomancer.crossroads.integration.JEI.BeamExtractorCategory;
import com.Da_Technomancer.crossroads.integration.JEI.BeamTransmuteCategory;
import com.Da_Technomancer.crossroads.integration.JEI.BlastFurnaceCategory;
import com.Da_Technomancer.crossroads.integration.JEI.CentrifugeCategory;
import com.Da_Technomancer.crossroads.integration.JEI.CopshowiumCategory;
import com.Da_Technomancer.crossroads.integration.JEI.DetailedCrafterCategory;
import com.Da_Technomancer.crossroads.integration.JEI.FluidCoolingCategory;
import com.Da_Technomancer.crossroads.integration.JEI.HeatingCrucibleCategory;
import com.Da_Technomancer.crossroads.integration.JEI.MillstoneCategory;
import com.Da_Technomancer.crossroads.integration.JEI.OreCleanserCategory;
import com.Da_Technomancer.crossroads.integration.JEI.ReagInfoCategory;
import com.Da_Technomancer.crossroads.integration.JEI.ReagIngr;
import com.Da_Technomancer.crossroads.integration.JEI.ReagentIngredientHelper;
import com.Da_Technomancer.crossroads.integration.JEI.ReagentIngredientRenderer;
import com.Da_Technomancer.crossroads.integration.JEI.StampMillCategory;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import java.util.Collection;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEICrossroadsPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = new ResourceLocation("crossroads", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.millstone, 1), new ResourceLocation[]{MillstoneCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.stampMill, 1), new ResourceLocation[]{StampMillCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.fluidCoolingChamber, 1), new ResourceLocation[]{FluidCoolingCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.heatingCrucible, 1), new ResourceLocation[]{HeatingCrucibleCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.waterCentrifuge, 1), new ResourceLocation[]{CentrifugeCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.blastFurnace, 1), new ResourceLocation[]{BlastFurnaceCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.oreCleanser, 1), new ResourceLocation[]{OreCleanserCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.beamExtractor, 1), new ResourceLocation[]{BeamExtractorCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.beamReflector, 1), new ResourceLocation[]{BeamTransmuteCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.detailedCrafter, 1), new ResourceLocation[]{DetailedCrafterCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.reactionChamberGlass, 1), new ResourceLocation[]{AlchemyCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.reactionChamberCrystal, 1), new ResourceLocation[]{AlchemyCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.glasswareHolder, 1), new ResourceLocation[]{AlchemyCategory.ID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)CRBlocks.copshowiumCreationChamber, 1), new ResourceLocation[]{CopshowiumCategory.ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(DetailedCrafterContainer.class, DetailedCrafterCategory.ID, 1, 9, 10, 36);
        registration.addRecipeTransferHandler(DetailedCrafterContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.MILL_TYPE), MillstoneCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.STAMP_MILL_TYPE), StampMillCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.FLUID_COOLING_TYPE), FluidCoolingCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.CRUCIBLE_TYPE), HeatingCrucibleCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.CENTRIFUGE_TYPE), CentrifugeCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.BLAST_FURNACE_TYPE), BlastFurnaceCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.ORE_CLEANSER_TYPE), OreCleanserCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.BEAM_EXTRACT_TYPE), BeamExtractorCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.BEAM_TRANSMUTE_TYPE), BeamTransmuteCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.DETAILED_TYPE), DetailedCrafterCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.ALCHEMY_TYPE), AlchemyCategory.ID);
        registration.addRecipes(JEICrossroadsPlugin.getRecipes(recipeManager, CRRecipes.COPSHOWIUM_TYPE), CopshowiumCategory.ID);
        registration.addRecipes(AlchemyCore.REAGENTS.values(), ReagInfoCategory.ID);
    }

    private static Collection<?> getRecipes(RecipeManager manage, IRecipeType<?> type) {
        return manage.func_199510_b().parallelStream().filter(rec -> rec.func_222127_g() == type && (!(rec instanceof IOptionalRecipe) || ((IOptionalRecipe)rec).isEnabled())).collect(Collectors.toList());
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        ReagIngr.populate();
        registry.register(ReagIngr.REAG, ReagIngr.REAG_TYPES, (IIngredientHelper)new ReagentIngredientHelper(), (IIngredientRenderer)ReagentIngredientRenderer.RENDERER);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MillstoneCategory(guiHelper), new FluidCoolingCategory(guiHelper), new HeatingCrucibleCategory(guiHelper), new DetailedCrafterCategory(guiHelper), new BeamExtractorCategory(guiHelper), new AlchemyCategory(guiHelper), new ReagInfoCategory(guiHelper), new StampMillCategory(guiHelper), new OreCleanserCategory(guiHelper), new BlastFurnaceCategory(guiHelper), new BeamTransmuteCategory(guiHelper), new CentrifugeCategory(guiHelper), new CopshowiumCategory(guiHelper)});
    }

    protected static IDrawableStatic createFluidOverlay(IGuiHelper helper) {
        return helper.drawableBuilder(new ResourceLocation("crossroads", "textures/gui/rectangle_fluid_overlay.png"), 0, 0, 16, 64).setTextureSize(64, 64).build();
    }
}

