/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.recipes.MillRec;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class MillstoneCategory
implements IRecipeCategory<MillRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", ".millstone");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;

    protected MillstoneCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("crossroads", "textures/gui/container/millstone_gui.png"), 66, 35, 44, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("crossroads", "textures/gui/container/millstone_gui.png"), 176, 0, 44, 17), 40, IDrawableAnimated.StartDirection.TOP, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.millstone, 1));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends MillRec> getRecipeClass() {
        return MillRec.class;
    }

    public String getTitle() {
        return CRBlocks.millstone.func_200291_n().func_150254_d();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MillRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void draw(MillRec recipe, double mouseX, double mouseY) {
        this.slot.draw(79, 16);
        this.slot.draw(61, 52);
        this.slot.draw(79, 52);
        this.slot.draw(97, 52);
        this.arrowStatic.draw(66, 35);
        this.arrow.draw(66, 35);
    }

    public void setRecipe(IRecipeLayout recipeLayout, MillRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 79, 16);
        itemStackGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        int length = recipe.getOutputs().length;
        if (length >= 1) {
            itemStackGroup.init(1, false, 61, 52);
            itemStackGroup.set(1, recipe.getOutputs()[0]);
            if (length >= 2) {
                itemStackGroup.init(2, false, 79, 52);
                itemStackGroup.set(2, recipe.getOutputs()[1]);
                if (length >= 3) {
                    itemStackGroup.init(3, false, 97, 52);
                    itemStackGroup.set(3, recipe.getOutputs()[2]);
                }
            }
        }
        itemStackGroup.set(ingredients);
    }
}

