/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.integration.JEI.JEICrossroadsPlugin;
import com.Da_Technomancer.crossroads.items.crafting.recipes.OreCleanserRec;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class OreCleanserCategory
implements IRecipeCategory<OreCleanserRec> {
    public static final ResourceLocation ID = new ResourceLocation("crossroads", "ore_cleanser");
    private final IDrawable back;
    private final IDrawable slot;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic arrowStatic;
    private final IDrawable fluidOverlay;
    private final IDrawable icon;

    protected OreCleanserCategory(IGuiHelper guiHelper) {
        this.back = guiHelper.createBlankDrawable(180, 100);
        this.slot = guiHelper.getSlotDrawable();
        this.arrowStatic = guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 79, 35, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(new ResourceLocation("textures/gui/container/furnace.png"), 176, 14, 24, 17), 40, IDrawableAnimated.StartDirection.LEFT, false);
        this.fluidOverlay = JEICrossroadsPlugin.createFluidOverlay(guiHelper);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)CRBlocks.oreCleanser, 1));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends OreCleanserRec> getRecipeClass() {
        return OreCleanserRec.class;
    }

    public String getTitle() {
        return CRBlocks.oreCleanser.func_200291_n().func_150254_d();
    }

    public IDrawable getBackground() {
        return this.back;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(OreCleanserRec recipe, double mouseX, double mouseY) {
        this.slot.draw(54, 50);
        this.slot.draw(110, 50);
        this.arrowStatic.draw(78, 50);
        this.arrow.draw(78, 50);
    }

    public void setRecipe(IRecipeLayout layout, OreCleanserRec recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemGroup = layout.getItemStacks();
        IGuiFluidStackGroup fluidGroup = layout.getFluidStacks();
        itemGroup.init(0, true, 54, 50);
        itemGroup.set(0, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        itemGroup.init(1, false, 110, 50);
        itemGroup.set(1, recipe.func_77571_b());
        fluidGroup.init(0, true, 34, 30, 16, 64, 1000, true, this.fluidOverlay);
        fluidGroup.set(0, new FluidStack((Fluid)CRFluids.steam.still, 250));
        fluidGroup.init(1, false, 130, 30, 16, 64, 1000, true, this.fluidOverlay);
        fluidGroup.set(1, new FluidStack((Fluid)CRFluids.dirtyWater.still, 250));
        itemGroup.set(ingredients);
        fluidGroup.set(ingredients);
    }

    public void setIngredients(OreCleanserRec recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)CRFluids.steam.still, 250));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack((Fluid)CRFluids.dirtyWater.still, 250));
    }
}

