/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.integration.JEI;

import com.Da_Technomancer.crossroads.API.alchemy.EnumMatterPhase;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.integration.JEI.ReagIngr;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.util.HashSet;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class ReagentIngredientHelper
implements IIngredientHelper<ReagIngr> {
    public ItemStack getCheatItemStack(ReagIngr ingredient) {
        ItemStack toGive = new ItemStack((IItemProvider)CRItems.phialCrystal, 1);
        ReagentMap reags = new ReagentMap();
        reags.addReagent(ingredient.getReag(), CRItems.phialCrystal.getCapacity(), 50.0);
        CRItems.phialCrystal.setReagents(toGive, reags);
        return toGive;
    }

    public boolean isValidIngredient(ReagIngr ingredient) {
        return ingredient != null && ingredient.getReag() != null && ingredient.getParts() >= 0;
    }

    public ReagIngr getMatch(Iterable<ReagIngr> ingredients, ReagIngr ingredientToMatch) {
        for (ReagIngr r : ingredients) {
            if (r.getReag() != ingredientToMatch.getReag()) continue;
            return r;
        }
        return null;
    }

    public String getDisplayName(ReagIngr ingredient) {
        return ingredient.getReag().getName();
    }

    public String getUniqueId(ReagIngr ingredient) {
        return "crossroads:" + ingredient.getReag().getId();
    }

    public String getWildcardId(ReagIngr ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(ReagIngr ingredient) {
        return "crossroads";
    }

    public Iterable<Integer> getColors(ReagIngr ingredient) {
        HashSet<Integer> out = new HashSet<Integer>();
        for (EnumMatterPhase p : EnumMatterPhase.values()) {
            out.add(ingredient.getReag().getColor(p).getRGB());
        }
        return out;
    }

    public String getResourceId(ReagIngr ingredient) {
        return ingredient.getReag().getName();
    }

    public ReagIngr copyIngredient(ReagIngr ingredient) {
        return ingredient;
    }

    public ReagIngr normalizeIngredient(ReagIngr ingredient) {
        return ingredient.getParts() <= 1 ? ingredient : new ReagIngr(ingredient.getReag(), 1);
    }

    public String getErrorInfo(ReagIngr ingredient) {
        if (ingredient.getReag() == null) {
            return "ID: NULL; Name: NULL; Parts: " + ingredient.getParts();
        }
        return "ID: " + ingredient.getReag().getId() + "; NAME: " + ingredient.getReag().getName() + "; PARTS: " + ingredient.getParts();
    }
}

