/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.alchemy;

import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.awt.Color;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractGlassware
extends Item {
    private static final String TAG_NAME = "reagents";
    protected final GlasswareTypes type;
    protected final boolean isCrystal;

    protected AbstractGlassware(GlasswareTypes type, boolean isCrystal) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(CRItems.TAB_CROSSROADS));
        this.type = type;
        this.isCrystal = isCrystal;
    }

    public int getCapacity() {
        return this.type.capacity;
    }

    public boolean isCrystal() {
        return this.isCrystal;
    }

    public static int getColorRGB(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof AbstractGlassware)) {
            return -1;
        }
        ReagentMap reags = ((AbstractGlassware)stack.func_77973_b()).getReagants(stack);
        int r = 0;
        int g = 0;
        int b = 0;
        int a = 0;
        int amount = reags.getTotalQty();
        if (amount <= 0) {
            return ((AbstractGlassware)stack.func_77973_b()).isCrystal() ? -3092225 : -3092272;
        }
        double temp = reags.getTempC();
        for (IReagent reag : reags.keySet()) {
            int qty = reags.getQty(reag);
            if (qty == 0) continue;
            Color color = reag.getColor(reag.getPhase(temp));
            r += qty * color.getRed();
            g += qty * color.getGreen();
            b += qty * color.getBlue();
            a += qty * color.getAlpha();
        }
        return new Color(r / amount, g / amount, b / amount, a / amount).getRGB();
    }

    @Nonnull
    public ReagentMap getReagants(ItemStack stack) {
        return stack.func_77942_o() ? ReagentMap.readFromNBT(stack.func_77978_p().func_74775_l(TAG_NAME)) : new ReagentMap();
    }

    public void setReagents(ItemStack stack, ReagentMap reagents) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT nbt = new CompoundNBT();
        stack.func_77978_p().func_218657_a(TAG_NAME, (INBT)nbt);
        reagents.write(nbt);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_capacity", new Object[]{this.getCapacity()}));
        if (!stack.func_77942_o()) {
            return;
        }
        ReagentMap stored = this.getReagants(stack);
        double temp = stored.getTempC();
        if (stored.getTotalQty() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_empty", new Object[0]));
        } else {
            HeatUtil.addHeatInfo(tooltip, temp, -32768.0);
            int total = 0;
            for (IReagent type : stored.keySet()) {
                int qty = stored.getQty(type);
                if (qty <= 0) continue;
                if (++total > 4 && flagIn == ITooltipFlag.TooltipFlags.NORMAL) break;
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_content", new Object[]{type.getName(), qty}));
            }
            if (total > 4 && flagIn == ITooltipFlag.TooltipFlags.NORMAL) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.alchemy_excess", new Object[]{total - 4}));
            }
        }
    }

    public GlasswareTypes containerType() {
        return this.type;
    }

    public static enum GlasswareTypes implements IStringSerializable
    {
        NONE(0, false),
        PHIAL(20, false),
        FLORENCE(100, true),
        SHELL(20, false);

        public final int capacity;
        public final boolean connectToCable;

        private GlasswareTypes(int capacity, boolean cableHeat) {
            this.capacity = capacity;
            this.connectToCable = cableHeat;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

