/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.alchemy;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.integration.curios.CurioHelper;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.LeydenJar;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TeslaRay
extends Item {
    private static final int FE_USE = 1000;
    private static final int RANGE = 12;
    private static final int RADIUS = 5;
    private static final float DAMAGE = 7.0f;

    public TeslaRay() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "tesla_ray";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_ray.desc", new Object[0]));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.tesla_ray.leyden", new Object[0]));
        tooltip.add(new TranslationTextComponent("tt.crossroads.tesla_ray.quip", new Object[0]).func_150255_a(MiscUtil.TT_QUIP));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        float scale = playerIn.func_184825_o(0.5f);
        if (worldIn.field_72995_K) {
            playerIn.func_184821_cY();
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        ItemStack leyden = CurioHelper.getEquipped(CRItems.leydenJar, (LivingEntity)playerIn);
        if (hand == Hand.MAIN_HAND && !leyden.func_190926_b() && LeydenJar.getCharge(leyden) >= 1000) {
            ArrayList<Object> targets = new ArrayList<Object>(4);
            List entities = worldIn.func_175647_a(LivingEntity.class, new AxisAlignedBB(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v, playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v).func_186662_g(12.0), EntityPredicates.field_94557_a);
            Predicate<LivingEntity> cannotTarget = e -> targets.contains(e) || e == playerIn || e instanceof ServerPlayerEntity && !playerIn.func_96122_a((PlayerEntity)e);
            Vec3d look = playerIn.func_70040_Z();
            Vec3d playPos = playerIn.func_174824_e(0.0f);
            entities.removeIf(e -> {
                Vec3d ePos = e.func_174791_d().func_178788_d(playPos);
                return ePos.func_72431_c(look).func_189985_c() > 25.0 || ePos.func_72430_b(look) > 12.0 || ePos.func_72430_b(look) < 0.0 || cannotTarget.test((LivingEntity)e);
            });
            double minDist = 2.147483647E9;
            LivingEntity closest = null;
            for (LivingEntity e2 : entities) {
                if (!(e2.func_174791_d().func_72436_e(playPos) < minDist)) continue;
                minDist = e2.func_174791_d().func_72436_e(playPos);
                closest = e2;
            }
            if (closest == null) {
                return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
            }
            LeydenJar.setCharge(leyden, LeydenJar.getCharge(leyden) - 1000);
            targets.add(closest);
            closest.func_70097_a(DamageSource.field_180137_b, 7.0f * scale);
            if (scale >= 0.99f) {
                for (int i = 0; i < 32; ++i) {
                    entities = worldIn.func_175647_a(LivingEntity.class, new AxisAlignedBB(((LivingEntity)targets.get((int)i)).field_70165_t, ((LivingEntity)targets.get((int)i)).field_70163_u, ((LivingEntity)targets.get((int)i)).field_70161_v, ((LivingEntity)targets.get((int)i)).field_70165_t, ((LivingEntity)targets.get((int)i)).field_70163_u, ((LivingEntity)targets.get((int)i)).field_70161_v).func_186662_g((double)(5 - i)), EntityPredicates.field_94557_a);
                    entities.removeIf(cannotTarget);
                    if (entities.isEmpty()) break;
                    targets.add((LivingEntity)entities.get((int)(Math.random() * (double)entities.size())));
                    ((LivingEntity)targets.get(i + 1)).func_70097_a(DamageSource.field_180137_b, 7.0f * scale);
                }
            }
            targets.add(0, playerIn);
            for (int i = 0; i < targets.size() - 1; ++i) {
                Vec3d start = ((LivingEntity)targets.get(i)).func_174791_d();
                if (i == 0) {
                    double angleOffset = 30.0 * (playerIn.func_184591_cq() == HandSide.LEFT ? -1.0 : 1.0);
                    start = start.func_72441_c(-Math.sin(Math.toRadians((double)playerIn.field_70177_z + angleOffset)) * (double)0.4f, 0.8, Math.cos(Math.toRadians((double)playerIn.field_70177_z + angleOffset)) * (double)0.4f);
                }
                Vec3d end = ((LivingEntity)targets.get(i + 1)).func_174824_e(0.0f);
                CRRenderUtil.addArc(playerIn.field_70170_p, start, end, 1, 0.0f, TeslaCoilTopTileEntity.COLOR_CODES[(int)(Math.random() * 3.0)]);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(hand));
        }
        return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(hand));
    }
}

