/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BlockIngredient;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class BeamTransmuteRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final EnumBeamAlignments align;
    private final boolean voi;
    private final BlockIngredient ingr;
    private final Block output;
    private final int power;
    private final boolean active;

    public BeamTransmuteRec(ResourceLocation location, String name, EnumBeamAlignments align, boolean voi, BlockIngredient input, Block output, int power, boolean active) {
        this.id = location;
        this.group = name;
        this.ingr = input;
        this.align = align;
        this.voi = voi;
        this.output = output;
        this.power = power;
        this.active = active;
    }

    public EnumBeamAlignments getAlign() {
        return this.align;
    }

    public boolean isVoid() {
        return this.voi;
    }

    public BlockIngredient getIngr() {
        return this.isEnabled() ? this.ingr : BlockIngredient.EMPTY;
    }

    public Block getOutput() {
        return this.output;
    }

    public int getPower() {
        return Math.max(this.power, 0);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return true;
    }

    public boolean canApply(EnumBeamAlignments alignment, boolean voidBeam, int beamPower, BlockState state) {
        return alignment == this.align && voidBeam == this.voi && beamPower >= this.power && this.ingr.test(state);
    }

    @Override
    public ItemStack func_77572_b(IInventory inv) {
        return this.func_77571_b();
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.getOutput());
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.beamReflector);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.BEAM_TRANSMUTE_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.BEAM_TRANSMUTE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<BeamTransmuteRec> {
        public BeamTransmuteRec read(ResourceLocation recipeId, JsonObject json) {
            EnumBeamAlignments align;
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new BeamTransmuteRec(recipeId, s, EnumBeamAlignments.NO_MATCH, false, BlockIngredient.EMPTY, Blocks.field_150350_a, 0, false);
            }
            String alignName = JSONUtils.func_151200_h((JsonObject)json, (String)"alignment");
            try {
                align = EnumBeamAlignments.valueOf(alignName.toUpperCase(Locale.US));
            }
            catch (NullPointerException e) {
                throw new JsonParseException("Non-existent alignment specified");
            }
            boolean voidBeam = JSONUtils.func_151209_a((JsonObject)json, (String)"void", (boolean)false);
            int power = JSONUtils.func_151208_a((JsonObject)json, (String)"power", (int)1);
            BlockIngredient in = CraftingUtil.getBlockIngredient((JsonElement)json, "input", false);
            ResourceLocation outName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"output"));
            Block created = (Block)ForgeRegistries.BLOCKS.getValue(outName);
            if (created == null) {
                throw new JsonParseException("Non-existent output specified");
            }
            return new BeamTransmuteRec(recipeId, s, align, voidBeam, in, created, power, true);
        }

        @Nullable
        public BeamTransmuteRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            boolean active = buffer.readBoolean();
            if (active) {
                EnumBeamAlignments align = EnumBeamAlignments.values()[buffer.func_150792_a()];
                boolean voi = buffer.readBoolean();
                int power = buffer.func_150792_a();
                Block out = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
                BlockIngredient input = BlockIngredient.readFromBuffer(buffer);
                return new BeamTransmuteRec(recipeId, s, align, voi, input, out, power, true);
            }
            return new BeamTransmuteRec(recipeId, s, EnumBeamAlignments.NO_MATCH, false, BlockIngredient.EMPTY, Blocks.field_150350_a, 0, false);
        }

        public void write(PacketBuffer buffer, BeamTransmuteRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            buffer.func_150787_b(recipe.align.ordinal());
            buffer.writeBoolean(recipe.voi);
            buffer.func_150787_b(recipe.power);
            buffer.func_192572_a(recipe.output.getRegistryName());
            recipe.ingr.writeToBuffer(buffer);
        }
    }
}

