/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.Da_Technomancer.crossroads.tileentities.fluid.WaterCentrifugeTileEntity;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CentrifugeRec
implements IOptionalRecipe<IInventory> {
    private static final Random RAND = new Random();
    private final ResourceLocation id;
    private final String group;
    private final FluidStack input;
    private final FluidStack fluidOutput;
    private final WeightOutput[] outputs;
    private final boolean active;

    public CentrifugeRec(ResourceLocation location, String name, FluidStack input, FluidStack fluidOutput, WeightOutput[] outputs, boolean active) {
        this.id = location;
        this.group = name;
        this.input = input;
        this.fluidOutput = fluidOutput;
        this.outputs = outputs;
        this.active = active;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && inv instanceof WaterCentrifugeTileEntity && BlockUtil.sameFluid((FluidStack)((WaterCentrifugeTileEntity)inv).getInputFluid(), (FluidStack)this.input) && ((WaterCentrifugeTileEntity)inv).getInputFluid().getAmount() >= this.input.getAmount();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public List<ItemStack> getOutputList() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(this.outputs.length);
        for (WeightOutput output : this.outputs) {
            out.add(output.item);
        }
        return out;
    }

    public ItemStack func_77571_b() {
        int totalWeight = 0;
        for (WeightOutput out : this.outputs) {
            totalWeight += out.weight;
        }
        int selected = RAND.nextInt(totalWeight);
        for (WeightOutput out : this.outputs) {
            if ((selected -= out.weight) > 0) continue;
            return out.item;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.waterCentrifuge);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.CENTRIFUGE_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.CENTRIFUGE_TYPE;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getFluidOutput() {
        return this.fluidOutput;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CentrifugeRec> {
        public CentrifugeRec read(ResourceLocation recipeId, JsonObject json) {
            WeightOutput[] outputs;
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new CentrifugeRec(recipeId, s, FluidStack.EMPTY, FluidStack.EMPTY, new WeightOutput[0], false);
            }
            FluidStack input = CraftingUtil.getFluidStack(json, "input");
            FluidStack outputFluid = CraftingUtil.getFluidStack(json, "output_fluid");
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"output")) {
                JsonArray arr = JSONUtils.func_151214_t((JsonObject)json, (String)"output");
                outputs = new WeightOutput[arr.size()];
                for (int i = 0; i < outputs.length; ++i) {
                    outputs[i] = Serializer.readOutput(arr.get(i).getAsJsonObject());
                }
            } else {
                outputs = new WeightOutput[]{Serializer.readOutput(JSONUtils.func_152754_s((JsonObject)json, (String)"output"))};
            }
            return new CentrifugeRec(recipeId, s, input, outputFluid, outputs, true);
        }

        private static WeightOutput readOutput(JsonObject json) {
            return new WeightOutput(CraftingUtil.getItemStack(json, "output", true, false), JSONUtils.func_151208_a((JsonObject)json, (String)"weight", (int)1));
        }

        @Nullable
        public CentrifugeRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new CentrifugeRec(recipeId, s, FluidStack.EMPTY, FluidStack.EMPTY, new WeightOutput[0], false);
            }
            FluidStack input = buffer.readFluidStack();
            FluidStack fluidOut = buffer.readFluidStack();
            WeightOutput[] outputs = new WeightOutput[buffer.func_150792_a()];
            for (int i = 0; i < outputs.length; ++i) {
                outputs[i] = WeightOutput.deserialize(buffer);
            }
            return new CentrifugeRec(recipeId, s, input, fluidOut, outputs, true);
        }

        public void write(PacketBuffer buffer, CentrifugeRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            buffer.writeFluidStack(recipe.input);
            buffer.writeFluidStack(recipe.fluidOutput);
            buffer.func_150787_b(recipe.outputs.length);
            for (WeightOutput out : recipe.outputs) {
                out.serialize(buffer);
            }
        }
    }

    private static class WeightOutput {
        private final ItemStack item;
        private final int weight;

        public WeightOutput(ItemStack item, int weight) {
            this.item = item;
            this.weight = weight;
        }

        private void serialize(PacketBuffer buf) {
            buf.func_150788_a(this.item);
            buf.func_150787_b(this.weight);
        }

        private static WeightOutput deserialize(PacketBuffer buf) {
            return new WeightOutput(buf.func_150791_c(), buf.func_150792_a());
        }
    }
}

