/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.crafting.recipes;

import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.CraftingUtil;
import com.Da_Technomancer.crossroads.items.crafting.recipes.IOptionalRecipe;
import com.Da_Technomancer.crossroads.tileentities.technomancy.CopshowiumCreationChamberTileEntity;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CopshowiumRec
implements IOptionalRecipe<IInventory> {
    private final ResourceLocation id;
    private final String group;
    private final FluidStack input;
    private final float mult;
    private final boolean flux;
    private final boolean active;

    public CopshowiumRec(ResourceLocation location, String name, FluidStack input, float expandFactor, boolean flux, boolean active) {
        this.id = location;
        this.group = name;
        this.input = input;
        this.mult = expandFactor;
        this.flux = flux;
        this.active = active;
    }

    @Override
    public boolean isEnabled() {
        return this.active;
    }

    public FluidStack getInput() {
        return this.input;
    }

    public float getMult() {
        return this.mult;
    }

    public boolean isFlux() {
        return this.flux;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.active && inv instanceof CopshowiumCreationChamberTileEntity && BlockUtil.sameFluid((FluidStack)((CopshowiumCreationChamberTileEntity)inv).getInputFluid(), (FluidStack)this.input);
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)CRBlocks.copshowiumCreationChamber);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return CRRecipes.COPSHOWIUM_SERIAL;
    }

    public String func_193358_e() {
        return this.group;
    }

    public IRecipeType<?> func_222127_g() {
        return CRRecipes.COPSHOWIUM_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CopshowiumRec> {
        public CopshowiumRec read(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            if (!CraftingUtil.isActiveJSON(json)) {
                return new CopshowiumRec(recipeId, s, FluidStack.EMPTY, 0.0f, false, false);
            }
            FluidStack input = CraftingUtil.getFluidStack(json, "input");
            input.setAmount(1000);
            float mult = JSONUtils.func_151221_a((JsonObject)json, (String)"mult", (float)1.0f);
            boolean flux = JSONUtils.func_151209_a((JsonObject)json, (String)"entropy", (boolean)false);
            return new CopshowiumRec(recipeId, s, input, mult, flux, true);
        }

        @Nullable
        public CopshowiumRec read(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            if (!buffer.readBoolean()) {
                return new CopshowiumRec(recipeId, s, FluidStack.EMPTY, 0.0f, false, false);
            }
            FluidStack input = FluidStack.readFromPacket((PacketBuffer)buffer);
            float mult = buffer.readFloat();
            boolean flux = buffer.readBoolean();
            return new CopshowiumRec(recipeId, s, input, mult, flux, true);
        }

        public void write(PacketBuffer buffer, CopshowiumRec recipe) {
            buffer.func_180714_a(recipe.func_193358_e());
            buffer.writeBoolean(recipe.active);
            recipe.getInput().writeToPacket(buffer);
            buffer.writeFloat(recipe.mult);
            buffer.writeBoolean(recipe.flux);
        }
    }
}

