/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.itemSets;

import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class GearFactory {
    private static final HashMap<String, GearMaterial> gearMats = new HashMap();
    private static final ArrayList<GearMaterial> gearMatList = new ArrayList();
    private static GearMaterial DEFAULT;

    public static GearMaterial findMaterial(String id) {
        return gearMats.getOrDefault(id.toLowerCase(Locale.US), GearFactory.getDefaultMaterial());
    }

    public static Collection<GearMaterial> getMaterials() {
        return gearMats.values();
    }

    public static void registerGearMaterial(GearMaterial mat) {
        gearMats.put(mat.getId().toLowerCase(Locale.US), mat);
        mat.pos = GearFactory.gearMatList.size();
        gearMatList.add(mat);
    }

    public static GearMaterial getDefaultMaterial() {
        return DEFAULT;
    }

    public static void init() {
        gearMatList.removeIf(OreSetup.OreProfile::wipeOnReload);
        gearMats.clear();
        gearMatList.forEach(mat -> gearMats.put(mat.getId(), (GearMaterial)mat));
        List rawInput = (List)CRConfig.gearTypes.get();
        for (String raw : rawInput) {
            Color col;
            int spaceIndex = raw.indexOf(32);
            String metal = raw.substring(0, spaceIndex);
            String colorString = '#' + raw.substring(spaceIndex + 1, spaceIndex + 7);
            try {
                col = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                col = Color.getHSBColor((float)Math.random(), 1.0f, 1.0f);
            }
            double density = Double.parseDouble(raw.substring(spaceIndex + 8));
            GearMaterial typ = new GearMaterial(metal, density, col);
            GearFactory.registerGearMaterial(typ);
        }
        DEFAULT = gearMats.get("iron");
        if (DEFAULT == null) {
            IllegalArgumentException e = new IllegalArgumentException("Default Gear Material not registered!");
            Crossroads.logger.error("Config Modified to prevent registering default gear material (iron)", (Throwable)e);
            throw e;
        }
    }

    public static class GearMaterial
    extends OreSetup.OreProfile {
        private final double density;
        private int pos;

        public GearMaterial(String nameIn, double matDensity, Color matColor) {
            this(nameIn, matDensity, matColor, true);
        }

        public GearMaterial(String nameIn, double matDensity, Color matColor, boolean shouldReload) {
            super(nameIn, matColor, shouldReload);
            this.density = matDensity;
        }

        public double getDensity() {
            return this.density;
        }

        public int serialize() {
            return this.pos;
        }

        public static GearMaterial deserialize(int serial) {
            if (serial < 0 || serial >= gearMatList.size()) {
                return GearFactory.getDefaultMaterial();
            }
            return (GearMaterial)gearMatList.get(serial);
        }
    }
}

