/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.itemSets;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.items.itemSets.OreProfileItem;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GearMatItem
extends OreProfileItem {
    protected static final Item.Properties itemProp = new Item.Properties().func_200916_a(CRItems.TAB_GEAR);

    protected GearMatItem() {
        super(itemProp);
    }

    public static GearFactory.GearMaterial getMaterial(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return GearFactory.getDefaultMaterial();
        }
        String matKey = stack.func_77978_p().func_74779_i("material");
        return GearFactory.findMaterial(matKey);
    }

    @Override
    protected OreSetup.OreProfile getSelfProfile(ItemStack stack) {
        return GearMatItem.getMaterial(stack);
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (GearFactory.GearMaterial mat : GearFactory.getMaterials()) {
                items.add((Object)this.withMaterial(mat, 1));
            }
        }
    }

    protected abstract double shapeFactor();

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        GearFactory.GearMaterial mat = GearMatItem.getMaterial(stack);
        if (mat != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.inertia", new Object[]{MiscUtil.preciseRound(mat.getDensity() * this.shapeFactor(), 3)}));
        }
    }
}

