/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.items.technomancy;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeamCage
extends Item {
    public static final int CAPACITY = 2048;

    public BeamCage() {
        super(new Item.Properties().func_200916_a(CRItems.TAB_CROSSROADS).func_200917_a(1));
        String name = "beam_cage";
        this.setRegistryName(name);
        CRItems.toRegister.add(this);
    }

    @Nonnull
    public static BeamUnit getStored(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return BeamUnit.EMPTY;
        }
        BeamUnit stored = BeamUnit.readFromNBT("beam", nbt);
        return stored.getPower() == 0 ? BeamUnit.EMPTY : stored;
    }

    public static void storeBeam(ItemStack stack, @Nonnull BeamUnit toStore) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            stack.func_77982_d(new CompoundNBT());
            nbt = stack.func_77978_p();
        }
        if (toStore.getEnergy() > 2048 || toStore.getPotential() > 2048 || toStore.getStability() > 2048 || toStore.getVoid() > 2048) {
            toStore = new BeamUnit(Math.min(2048, toStore.getEnergy()), Math.min(2048, toStore.getPotential()), Math.min(2048, toStore.getStability()), Math.min(2048, toStore.getVoid()));
        }
        toStore.writeToNBT("beam", nbt);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this, 1));
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            BeamCage.storeBeam(stack, new BeamUnit(2048, 2048, 2048, 2048));
            items.add((Object)stack);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        BeamUnit stored = BeamCage.getStored(stack);
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.energy", new Object[]{stored.getEnergy(), 2048}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.potential", new Object[]{stored.getPotential(), 2048}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.stability", new Object[]{stored.getStability(), 2048}));
        tooltip.add((ITextComponent)new TranslationTextComponent("tt.crossroads.beam_cage.void", new Object[]{stored.getVoid(), 2048}));
    }
}

