/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render;

import com.Da_Technomancer.crossroads.API.packets.AddVisualToClient;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SafeCallable;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.Da_Technomancer.crossroads.render.LooseArcRenderable;
import com.Da_Technomancer.crossroads.render.LooseBeamRenderable;
import com.mojang.blaze3d.platform.GLX;
import java.util.function.Function;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CRRenderUtil {
    public static final Vec3d VEC_I = new Vec3d(1.0, 0.0, 0.0);
    public static final Vec3d VEC_J = new Vec3d(0.0, 1.0, 0.0);
    public static final Vec3d VEC_K = new Vec3d(0.0, 0.0, 1.0);
    public static final Function<CompoundNBT, IVisualEffect>[] visualFactories = new Function[2];

    public static void addBeam(World world, double x, double y, double z, double length, float angleX, float angleY, byte width, int color) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("id", 0);
        nbt.func_74780_a("x", x);
        nbt.func_74780_a("y", y);
        nbt.func_74780_a("z", z);
        nbt.func_74780_a("length", length);
        nbt.func_74776_a("angle_x", angleX);
        nbt.func_74776_a("angle_y", angleY);
        nbt.func_74774_a("width", width);
        nbt.func_74768_a("color", color);
        CRPackets.sendPacketAround(world, new BlockPos(x, y, z), new AddVisualToClient(nbt));
    }

    public static void addArc(World world, Vec3d start, Vec3d end, int count, float diffusionRate, int color) {
        CRRenderUtil.addArc(world, (float)start.field_72450_a, (float)start.field_72448_b, (float)start.field_72449_c, (float)end.field_72450_a, (float)end.field_72448_b, (float)end.field_72449_c, count, diffusionRate, color);
    }

    public static void addArc(World world, float xSt, float ySt, float zSt, float xEn, float yEn, float zEn, int count, float diffusionRate, int color) {
        CRRenderUtil.addArc(world, xSt, ySt, zSt, xEn, yEn, zEn, xSt, ySt, zSt, count, diffusionRate, (byte)10, color);
    }

    public static void addArc(World world, float xSt, float ySt, float zSt, float xEn, float yEn, float zEn, float xStFin, float yStFin, float zStFin, int count, float diffusionRate, byte lifespan, int color) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("id", 1);
        nbt.func_74776_a("x", xSt);
        nbt.func_74776_a("y", ySt);
        nbt.func_74776_a("z", zSt);
        nbt.func_74776_a("x_e", xEn);
        nbt.func_74776_a("y_e", yEn);
        nbt.func_74776_a("z_e", zEn);
        nbt.func_74776_a("x_f", xStFin);
        nbt.func_74776_a("y_f", yStFin);
        nbt.func_74776_a("z_f", zStFin);
        nbt.func_74768_a("count", count);
        nbt.func_74776_a("diffu", diffusionRate);
        nbt.func_74768_a("color", color);
        nbt.func_74774_a("lif", lifespan);
        if (world.field_72995_K) {
            SafeCallable.effectsToRender.add(visualFactories[1].apply(nbt));
        } else {
            CRPackets.sendPacketAround(world, new BlockPos((double)xSt, (double)ySt, (double)zSt), new AddVisualToClient(nbt));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getCurrLighting() {
        return (int)GLX.lastBrightnessY << 16 | (int)GLX.lastBrightnessX & 0xFF;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setLighting(int light) {
        int j = light & 0xFF;
        int k = light >> 16 & 0xFF;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setMediumLighting() {
        CRRenderUtil.setLighting(41120);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setBrightLighting() {
        CRRenderUtil.setLighting(61680);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void draw3dLine(BufferBuilder buf, Vec3d start, Vec3d end, double width) {
        Vec3d lineVec = end.func_178788_d(start);
        Vec3d[] perpVec = new Vec3d[3];
        perpVec[0] = lineVec.func_72431_c(VEC_I);
        if (perpVec[0].func_189985_c() == 0.0) {
            perpVec[0] = lineVec.func_72431_c(VEC_J);
        }
        perpVec[0] = perpVec[0].func_186678_a(width * Math.sqrt(3.0) / 4.0 / perpVec[0].func_72433_c());
        Vec3d compA = perpVec[0].func_186678_a(-0.5);
        Vec3d compB = perpVec[0].func_72431_c(lineVec.func_72432_b()).func_186678_a(Math.sqrt(3.0) / 2.0);
        perpVec[1] = compA.func_178787_e(compB);
        perpVec[2] = compA.func_178788_d(compB);
        for (int i = 0; i < 3; ++i) {
            Vec3d offsetPrev = perpVec[i];
            Vec3d offsetNext = perpVec[(i + 1) % perpVec.length];
            buf.func_181662_b(start.func_82615_a() + offsetPrev.func_82615_a(), start.func_82617_b() + offsetPrev.func_82617_b(), start.func_82616_c() + offsetPrev.func_82616_c()).func_181675_d();
            buf.func_181662_b(end.func_82615_a() + offsetPrev.func_82615_a(), end.func_82617_b() + offsetPrev.func_82617_b(), end.func_82616_c() + offsetPrev.func_82616_c()).func_181675_d();
            buf.func_181662_b(end.func_82615_a() + offsetNext.func_82615_a(), end.func_82617_b() + offsetNext.func_82617_b(), end.func_82616_c() + offsetNext.func_82616_c()).func_181675_d();
            buf.func_181662_b(start.func_82615_a() + offsetNext.func_82615_a(), start.func_82617_b() + offsetNext.func_82617_b(), start.func_82616_c() + offsetNext.func_82616_c()).func_181675_d();
        }
    }

    static {
        CRRenderUtil.visualFactories[0] = LooseBeamRenderable::readFromNBT;
        CRRenderUtil.visualFactories[1] = LooseArcRenderable::readFromNBT;
    }
}

