/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render;

import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Vec3d;

public class LooseArcRenderable
implements IVisualEffect {
    private final float xSt;
    private final float ySt;
    private final float zSt;
    private final float xEn;
    private final float yEn;
    private final float zEn;
    private final float xStFin;
    private final float yStFin;
    private final float zStFin;
    private final int count;
    private final float diffusionRate;
    private final int color;
    private byte lifeTime;
    private final byte lifeSpan;
    private long lastTick = -1L;
    private final Vec3d[][] states;

    private LooseArcRenderable(float xSt, float ySt, float zSt, float xEn, float yEn, float zEn, float xStFin, float yStFin, float zStFin, int count, float diffusionRate, byte lifespan, int color) {
        this.xSt = xSt;
        this.ySt = ySt;
        this.zSt = zSt;
        this.xEn = xEn;
        this.yEn = yEn;
        this.zEn = zEn;
        this.xStFin = xStFin;
        this.yStFin = yStFin;
        this.zStFin = zStFin;
        this.count = count;
        this.diffusionRate = diffusionRate;
        this.color = color;
        this.states = new Vec3d[count][9];
        this.lifeSpan = lifespan;
        this.lifeTime = lifespan;
    }

    public static LooseArcRenderable readFromNBT(CompoundNBT nbt) {
        return new LooseArcRenderable(nbt.func_74760_g("x"), nbt.func_74760_g("y"), nbt.func_74760_g("z"), nbt.func_74760_g("x_e"), nbt.func_74760_g("y_e"), nbt.func_74760_g("z_e"), nbt.func_74760_g("x_f"), nbt.func_74760_g("y_f"), nbt.func_74760_g("z_f"), nbt.func_74762_e("count"), nbt.func_74760_g("diffu"), nbt.func_74771_c("lif"), nbt.func_74762_e("color"));
    }

    @Override
    public boolean render(Tessellator tess, BufferBuilder buf, long worldTime, double playerX, double playerY, double playerZ, Vec3d playerLook, Random rand, float partialTicks) {
        float arcWidth = 0.03f;
        Color col = new Color(this.color, true);
        float mult = ((float)(this.lifeSpan - this.lifeTime) + partialTicks) / (float)this.lifeSpan;
        Vec3d start = new Vec3d((double)(mult * (this.xStFin - this.xSt) + this.xSt), (double)(mult * (this.yStFin - this.ySt) + this.ySt), (double)(mult * (this.zStFin - this.zSt) + this.zSt));
        GlStateManager.disableTexture();
        GlStateManager.color4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)((float)col.getAlpha() / 255.0f));
        GlStateManager.translated((double)(start.field_72450_a - playerX), (double)(start.field_72448_b - playerY), (double)(start.field_72449_c - playerZ));
        buf.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        if (this.lastTick != worldTime && this.lastTick < 0L) {
            Vec3d lengthVec = new Vec3d((double)this.xEn - start.field_72450_a, (double)this.yEn - start.field_72448_b, (double)this.zEn - start.field_72449_c);
            double length = lengthVec.func_72433_c();
            Vec3d crossVec = (lengthVec = lengthVec.func_72432_b()).func_72431_c(CRRenderUtil.VEC_I);
            if (crossVec.func_189985_c() == 0.0) {
                crossVec = lengthVec.func_72431_c(CRRenderUtil.VEC_J);
            }
            crossVec = crossVec.func_72432_b();
            double angle = Math.PI * 2 / (double)this.count;
            for (int i = 0; i < this.count; ++i) {
                boolean diverged = rand.nextFloat() < this.diffusionRate;
                for (int node = 0; node < this.states[0].length; ++node) {
                    double portion = -0.012229 * Math.pow(node, 2.0) + 0.222835 * (double)node - 0.0030303;
                    if (portion < 0.0) {
                        portion = 0.0;
                    }
                    this.states[i][node] = lengthVec.func_186678_a(portion * length).func_178787_e(crossVec.func_186678_a(length / 6.0 * (diverged ? Math.sqrt(portion) : Math.sqrt(portion) - Math.pow(portion, 2.0))));
                    if (node == 0 || node == this.states[i].length - 1) continue;
                    this.states[i][node] = this.states[i][node].func_72441_c(rand.nextDouble() / 4.0, rand.nextDouble() / 4.0, rand.nextDouble() / 4.0);
                }
                crossVec = crossVec.func_186678_a(Math.cos(angle)).func_178787_e(crossVec.func_72431_c(lengthVec).func_186678_a(Math.sin(angle)));
            }
        }
        for (int i = 0; i < this.count; ++i) {
            for (int node = 1; node < this.states[0].length; ++node) {
                CRRenderUtil.draw3dLine(buf, this.states[i][node - 1], this.states[i][node], 0.03f);
            }
        }
        tess.func_78381_a();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableTexture();
        if (this.lastTick != worldTime) {
            this.lastTick = worldTime;
            this.lifeTime = (byte)(this.lifeTime - 1);
            return this.lifeTime < 0;
        }
        return false;
    }
}

