/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render;

import com.Da_Technomancer.crossroads.API.beams.BeamUtil;
import com.Da_Technomancer.crossroads.render.IVisualEffect;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.Vec3d;

public class LooseBeamRenderable
implements IVisualEffect {
    public final double x;
    public final double y;
    public final double z;
    public final double length;
    public final float angleX;
    public final float angleY;
    public final byte width;
    public final int color;
    public byte lifeTime = (byte)6;
    public long lastTick = 0L;

    private LooseBeamRenderable(double x, double y, double z, double length, float angleX, float angleY, byte width, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.length = length;
        this.angleX = angleX;
        this.angleY = angleY;
        this.width = width;
        this.color = color;
    }

    public static LooseBeamRenderable readFromNBT(CompoundNBT nbt) {
        return new LooseBeamRenderable(nbt.func_74760_g("x"), nbt.func_74760_g("y"), nbt.func_74760_g("z"), nbt.func_74769_h("length"), nbt.func_74760_g("angle_x"), nbt.func_74760_g("angle_y"), nbt.func_74771_c("width"), nbt.func_74762_e("color"));
    }

    @Override
    public boolean render(Tessellator tess, BufferBuilder buf, long worldTime, double playerX, double playerY, double playerZ, Vec3d playerLook, Random rand, float partialTicks) {
        Color col = new Color(this.color);
        GlStateManager.color3f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f));
        GlStateManager.translated((double)(this.x - playerX), (double)(this.y - playerY), (double)(this.z - playerZ));
        GlStateManager.rotatef((float)(-this.angleY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(this.angleX + 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BeamUtil.BEAM_TEXT);
        double small = -((double)this.width / 16.0);
        double big = (double)this.width / 16.0;
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(small, this.length, big).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(small, 0.0, big).func_187315_a(1.0, this.length).func_181675_d();
        buf.func_181662_b(big, 0.0, big).func_187315_a(0.0, this.length).func_181675_d();
        buf.func_181662_b(big, this.length, big).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(big, this.length, small).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(big, 0.0, small).func_187315_a(1.0, this.length).func_181675_d();
        buf.func_181662_b(small, 0.0, small).func_187315_a(0.0, this.length).func_181675_d();
        buf.func_181662_b(small, this.length, small).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(small, this.length, small).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(small, 0.0, small).func_187315_a(1.0, this.length).func_181675_d();
        buf.func_181662_b(small, 0.0, big).func_187315_a(0.0, this.length).func_181675_d();
        buf.func_181662_b(small, this.length, big).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(big, this.length, big).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(big, 0.0, big).func_187315_a(1.0, this.length).func_181675_d();
        buf.func_181662_b(big, 0.0, small).func_187315_a(0.0, this.length).func_181675_d();
        buf.func_181662_b(big, this.length, small).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BeamUtil.BEAM_END_TEXT);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buf.func_181662_b(small, this.length, big).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(small, this.length, small).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(big, this.length, small).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(big, this.length, big).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(small, 0.0, big).func_187315_a(1.0, 0.0).func_181675_d();
        buf.func_181662_b(small, 0.0, small).func_187315_a(1.0, 1.0).func_181675_d();
        buf.func_181662_b(big, 0.0, small).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(big, 0.0, big).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.lastTick != worldTime) {
            this.lastTick = worldTime;
            byte by = this.lifeTime;
            this.lifeTime = (byte)(by - 1);
            return by < 0;
        }
        return false;
    }
}

