/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.beams.BeamManager;
import com.Da_Technomancer.crossroads.API.beams.BeamUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.technomancy.BeaconHarnessTileEntity;
import com.Da_Technomancer.essentials.render.LinkLineRenderer;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class BeaconHarnessRenderer
extends LinkLineRenderer<BeaconHarnessTileEntity> {
    private static final ResourceLocation INNER_TEXT = new ResourceLocation("crossroads", "textures/block/block_copshowium.png");
    private static final ResourceLocation OUTER_TEXT = new ResourceLocation("crossroads", "textures/block/block_pure_quartz.png");

    public void render(BeaconHarnessTileEntity beam, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!beam.func_145831_w().func_175667_e(beam.func_174877_v())) {
            return;
        }
        super.func_199341_a((TileEntity)beam, x, y, z, partialTicks, destroyStage);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        float angle = 0.0f;
        int[] beamPacket = beam.getRenderedBeams();
        Triple<Color, Integer, Integer> trip = BeamManager.getTriple(beamPacket[0]);
        if ((Integer)trip.getRight() != 0) {
            angle = BeaconHarnessRenderer.calcAngle(beam, partialTicks);
            GlStateManager.pushMatrix();
            GlStateManager.pushLightingAttributes();
            GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GlStateManager.color3f((float)((float)((Color)trip.getLeft()).getRed() / 255.0f), (float)((float)((Color)trip.getLeft()).getGreen() / 255.0f), (float)((float)((Color)trip.getLeft()).getBlue() / 255.0f));
            GlStateManager.disableLighting();
            GlStateManager.rotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
            CRRenderUtil.setBrightLighting();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BeamUtil.BEAM_TEXT);
            if (((Boolean)CRConfig.rotateBeam.get()).booleanValue()) {
                GlStateManager.rotated((double)(((float)beam.func_145831_w().func_82737_E() + partialTicks) * 2.0f), (double)0.0, (double)1.0, (double)0.0);
            }
            double rad = ((Integer)trip.getRight()).doubleValue() / 16.0 / Math.sqrt(2.0);
            int length = (Integer)trip.getMiddle();
            float stOffset = 0.4375f;
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_181662_b(-rad, (double)length, rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, rad).func_187315_a(1.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(rad, 0.4375, rad).func_187315_a(0.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(rad, (double)length, rad).func_187315_a(0.0, 0.0).func_181675_d();
            buf.func_181662_b(rad, (double)length, -rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(rad, 0.4375, -rad).func_187315_a(1.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, -rad).func_187315_a(0.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(-rad, (double)length, -rad).func_187315_a(0.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, (double)length, -rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, -rad).func_187315_a(1.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, rad).func_187315_a(0.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(-rad, (double)length, rad).func_187315_a(0.0, 0.0).func_181675_d();
            buf.func_181662_b(rad, (double)length, rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(rad, 0.4375, rad).func_187315_a(1.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(rad, 0.4375, -rad).func_187315_a(0.0, (double)((float)length - 0.4375f)).func_181675_d();
            buf.func_181662_b(rad, (double)length, -rad).func_187315_a(0.0, 0.0).func_181675_d();
            tes.func_78381_a();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(BeamUtil.BEAM_END_TEXT);
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buf.func_181662_b(-rad, (double)length, rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, (double)length, -rad).func_187315_a(1.0, 1.0).func_181675_d();
            buf.func_181662_b(rad, (double)length, -rad).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b(rad, (double)length, rad).func_187315_a(0.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, rad).func_187315_a(1.0, 0.0).func_181675_d();
            buf.func_181662_b(-rad, 0.4375, -rad).func_187315_a(1.0, 1.0).func_181675_d();
            buf.func_181662_b(rad, 0.4375, -rad).func_187315_a(0.0, 1.0).func_181675_d();
            buf.func_181662_b(rad, 0.4375, rad).func_187315_a(0.0, 0.0).func_181675_d();
            tes.func_78381_a();
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.enableLighting();
            GlStateManager.popAttributes();
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.disableLighting();
        GlStateManager.translated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        float smallOffset = 0.0928f;
        float medOffset = 0.25f;
        float largeOffset = 0.375f;
        GlStateManager.rotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(INNER_TEXT);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BeaconHarnessRenderer.addRod(buf, smallOffset, smallOffset);
        BeaconHarnessRenderer.addRod(buf, smallOffset, -smallOffset);
        BeaconHarnessRenderer.addRod(buf, -smallOffset, -smallOffset);
        BeaconHarnessRenderer.addRod(buf, -smallOffset, smallOffset);
        tes.func_78381_a();
        GlStateManager.rotated((double)(-2.0f * angle), (double)0.0, (double)1.0, (double)0.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(OUTER_TEXT);
        buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BeaconHarnessRenderer.addRod(buf, medOffset, largeOffset);
        BeaconHarnessRenderer.addRod(buf, medOffset, -largeOffset);
        BeaconHarnessRenderer.addRod(buf, -medOffset, largeOffset);
        BeaconHarnessRenderer.addRod(buf, -medOffset, -largeOffset);
        BeaconHarnessRenderer.addRod(buf, largeOffset, medOffset);
        BeaconHarnessRenderer.addRod(buf, largeOffset, -medOffset);
        BeaconHarnessRenderer.addRod(buf, -largeOffset, medOffset);
        BeaconHarnessRenderer.addRod(buf, -largeOffset, -medOffset);
        tes.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }

    private static void addRod(BufferBuilder buf, double x, double z) {
        float rad = 0.0625f;
        float minY = 0.0625f;
        float maxY = 0.9375f;
        buf.func_181662_b(x - (double)rad, (double)minY, z - (double)rad).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)maxY, z - (double)rad).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)maxY, z - (double)rad).func_187315_a((double)(2.0f * rad), 1.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)minY, z - (double)rad).func_187315_a((double)(2.0f * rad), 0.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)minY, z + (double)rad).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)minY, z + (double)rad).func_187315_a((double)(2.0f * rad), 0.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)maxY, z + (double)rad).func_187315_a((double)(2.0f * rad), 1.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)maxY, z + (double)rad).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)minY, z - (double)rad).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)minY, z + (double)rad).func_187315_a((double)(2.0f * rad), 0.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)maxY, z + (double)rad).func_187315_a((double)(2.0f * rad), 1.0).func_181675_d();
        buf.func_181662_b(x - (double)rad, (double)maxY, z - (double)rad).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)minY, z - (double)rad).func_187315_a(0.0, 0.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)maxY, z - (double)rad).func_187315_a(0.0, 1.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)maxY, z + (double)rad).func_187315_a((double)(2.0f * rad), 1.0).func_181675_d();
        buf.func_181662_b(x + (double)rad, (double)minY, z + (double)rad).func_187315_a((double)(2.0f * rad), 0.0).func_181675_d();
    }

    private static float calcAngle(BeaconHarnessTileEntity te, float partialTicks) {
        return (float)Math.toDegrees(((float)(te.func_145831_w().func_82737_E() % 20L) + partialTicks) * (float)Math.PI / 20.0f);
    }

    public boolean isGlobalRenderer(BeaconHarnessTileEntity te) {
        return true;
    }
}

