/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.technomancy.FluxSinkTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class FluxSinkRenderer
extends TileEntityRenderer<FluxSinkTileEntity> {
    private static final ResourceLocation TEXT = new ResourceLocation("crossroads", "textures/model/flux_sink_core.png");
    private static final ResourceLocation TEXT_OUTER = new ResourceLocation("crossroads", "textures/model/flux_sink_out.png");
    private static final double symmetryAxisAngle = (double)31.722f;
    private static final double symmetryAxisX = Math.cos(Math.toRadians(31.722f));
    private static final double symmetryAxisY = Math.sin(Math.toRadians(31.722f));
    private static final float goldRatio = (float)(1.0 + Math.sqrt(5.0)) / 2.0f;

    public void render(FluxSinkTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (te == null) {
            return;
        }
        double runtime = te.getRunDuration(partialTicks);
        if (runtime <= 0.0) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.disableCull();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        int light = CRRenderUtil.getCurrLighting();
        float scale = (float)Math.min(1.0, runtime / 60.0) * 2.5f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXT_OUTER);
        GlStateManager.pushMatrix();
        CRRenderUtil.setMediumLighting();
        GlStateManager.pushMatrix();
        GlStateManager.rotated((double)(runtime / 10.0), (double)0.0, (double)1.0, (double)0.0);
        double len = 4.0;
        double plateScale = Math.min(runtime / 40.0, 1.0) * 0.5;
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 8; ++i) {
                double yOffset = 0.4 * Math.sin(runtime / 100.0 + (double)(i * 5));
                float textVSt = (float)((i % 4 + (int)(runtime / 5.0)) % 4) / 4.0f;
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(4.0, yOffset - plateScale, -plateScale).func_187315_a(0.0, (double)textVSt).func_181675_d();
                vb.func_181662_b(4.0, yOffset + plateScale, -plateScale).func_187315_a(0.0, (double)textVSt + 0.25).func_181675_d();
                vb.func_181662_b(4.0, yOffset + plateScale, plateScale).func_187315_a(0.25, (double)textVSt + 0.25).func_181675_d();
                vb.func_181662_b(4.0, yOffset - plateScale, plateScale).func_187315_a(0.25, (double)textVSt).func_181675_d();
                tes.func_78381_a();
                GlStateManager.rotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.rotated((double)(8.0 * Math.sin(runtime / 40.0)), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)(8.0 * Math.cos(runtime / 40.0)), (double)0.0, (double)0.0, (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXT);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
        CRRenderUtil.setLighting(light);
        FluxSinkRenderer.drawIcos(vb, scale, 0.0f, 0.0f);
        CRRenderUtil.setMediumLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
        FluxSinkRenderer.drawIcos(vb, scale + 0.2f + (float)Math.sin(runtime / 20.0) * 0.08f, 1.0f, 1.0f);
        GlStateManager.popMatrix();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
    }

    private static void drawIcos(BufferBuilder vb, float scale, float cornerU, float cornerV) {
        float smallLen = scale / 2.0f;
        float largeLen = goldRatio * smallLen;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 5; ++j) {
                vb.func_181668_a(4, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(0.0, (double)largeLen, (double)smallLen).func_187315_a((double)cornerU, (double)cornerV).func_181675_d();
                vb.func_181662_b(0.0, (double)largeLen, (double)(-smallLen)).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)largeLen, (double)smallLen, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                vb.func_181662_b(0.0, (double)largeLen, (double)smallLen).func_187315_a((double)cornerU, (double)cornerV).func_181675_d();
                vb.func_181662_b(0.0, (double)largeLen, (double)(-smallLen)).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)(-largeLen), (double)smallLen, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.rotated((double)72.0, (double)symmetryAxisX, (double)symmetryAxisY, (double)0.0);
            }
            GlStateManager.rotated((double)36.0, (double)symmetryAxisX, (double)symmetryAxisY, (double)0.0);
            GlStateManager.rotated((double)180.0, (double)(-symmetryAxisY), (double)symmetryAxisX, (double)0.0);
        }
    }
}

