/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.technomancy.GatewayAddress;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.technomancy.GatewayFrameTileEntity;
import com.Da_Technomancer.essentials.render.LinkLineRenderer;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class GatewayFrameRenderer
extends LinkLineRenderer<GatewayFrameTileEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("crossroads", "textures/model/gateway.png");

    public void render(GatewayFrameTileEntity frame, double x, double y, double z, float partialTicks, int destroyStage) {
        int i;
        if (frame == null || !frame.func_145831_w().func_175667_e(frame.func_174877_v()) || !frame.isActive()) {
            return;
        }
        super.func_199341_a((TileEntity)frame, x, y, z, partialTicks, destroyStage);
        double radius = (double)frame.getSize() / 2.0;
        Direction.Axis plane = frame.getPlane();
        boolean linked = frame.chevrons[frame.chevrons.length - 1] != null;
        double dialingWheelAngle = frame.getAngle(partialTicks);
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.disableLighting();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        CRRenderUtil.setLighting(frame.func_145831_w().func_217338_b(frame.func_174877_v().func_177979_c(frame.getSize() / 5), 0));
        GlStateManager.translated((double)(x + 0.5), (double)(y + 1.0 - radius), (double)(z + 0.5));
        if (plane == Direction.Axis.Z) {
            GlStateManager.rotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
        }
        GlStateManager.scaled((double)radius, (double)radius, (double)1.0);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        double squareOut = 1.0;
        double squareIn = 0.6;
        double sqDepth = 0.5;
        double octOutLen = 1.0 * Math.cos(0.39269908169872414);
        double octInLen = 0.6 * Math.cos(0.39269908169872414);
        double octOutWid = 1.0 * Math.sqrt(2.0 - Math.sqrt(2.0)) / 2.0;
        double octInWid = 0.6 * Math.sqrt(2.0 - Math.sqrt(2.0)) / 2.0;
        double octDepth = 0.4;
        double triLen = 0.2;
        double triDepth = 0.025 * radius + 0.5;
        double iconEdgeRad = 0.078125;
        double iconBottom = octInLen + 0.03125;
        double iconTop = iconBottom + 0.15625;
        double iconEdgeZRad = 0.4;
        double iconEdgeXRad = 0.4 / radius;
        double zFightingOffset = 0.003;
        double iconDialBottom = 0.6 * (Math.sqrt(2.0) + 0.25);
        double iconDialTop = iconDialBottom + 0.15625;
        float symbolUSt = 0.0f;
        float symbolUEn = 0.125f;
        float polyUSt = 0.125f;
        float polyUEn = 0.75f;
        float sqFrUSt = 0.25f;
        float sqFrUEn = 0.625f;
        float sqFrVSt = 0.0f;
        float sqFrVEn = 0.125f;
        float sqInVSt = 0.125f;
        float sqInVEn = 0.25f;
        float sqOutVSt = 0.25f;
        float sqOutVEn = 0.375f;
        float octFrUSt = 0.1875f;
        float octFrUEn = 0.6875f;
        float octFrVSt = 0.375f;
        float octFrVEn = 0.5f;
        float octInVSt = 0.5f;
        float octInVEn = 0.625f;
        float octOutVSt = 0.625f;
        float octOutVEn = 0.75f;
        float triVSt = 0.75f;
        float triVEn = 1.0f;
        float triFrUEn = 0.375f;
        float triTopUSt = 0.375f;
        float triTopUEn = 0.40625f;
        float triFrUMid = 0.25f;
        float triEdgeUSt = 0.40625f;
        float triEdgeUEn = 0.4375f;
        float portalUSt = 0.75f;
        float portalUEn = 1.0f;
        float portalTexRad = 0.051f;
        float portalUMid1 = 0.824f;
        float portalUMid2 = 0.926f;
        float portalVSt = 0.25f * (float)((int)(frame.func_145831_w().func_82737_E() / 5L) % 4);
        float portalVEn = portalVSt + 0.25f;
        float portalVMid1 = (portalVSt + portalVEn) / 2.0f - 0.051f;
        float portalVMid2 = portalVMid1 + 0.102f;
        GlStateManager.pushMatrix();
        GlStateManager.rotated((double)Math.toDegrees(dialingWheelAngle), (double)0.0, (double)0.0, (double)1.0);
        for (i = 0; i < 8; ++i) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(octOutWid, octOutLen, 0.4).func_187315_a(0.75, 0.375).func_181675_d();
            vb.func_181662_b(-octOutWid, octOutLen, 0.4).func_187315_a(0.125, 0.375).func_181675_d();
            vb.func_181662_b(-octInWid, octInLen, 0.4).func_187315_a(0.1875, 0.5).func_181675_d();
            vb.func_181662_b(octInWid, octInLen, 0.4).func_187315_a(0.6875, 0.5).func_181675_d();
            vb.func_181662_b(octOutWid, octOutLen, -0.4).func_187315_a(0.75, 0.375).func_181675_d();
            vb.func_181662_b(octInWid, octInLen, -0.4).func_187315_a(0.6875, 0.5).func_181675_d();
            vb.func_181662_b(-octInWid, octInLen, -0.4).func_187315_a(0.1875, 0.5).func_181675_d();
            vb.func_181662_b(-octOutWid, octOutLen, -0.4).func_187315_a(0.125, 0.375).func_181675_d();
            vb.func_181662_b(octOutWid, octOutLen, -0.4).func_187315_a(0.75, 0.75).func_181675_d();
            vb.func_181662_b(-octOutWid, octOutLen, -0.4).func_187315_a(0.125, 0.75).func_181675_d();
            vb.func_181662_b(-octOutWid, octOutLen, 0.4).func_187315_a(0.125, 0.625).func_181675_d();
            vb.func_181662_b(octOutWid, octOutLen, 0.4).func_187315_a(0.75, 0.625).func_181675_d();
            vb.func_181662_b(octInWid, octInLen, -0.4).func_187315_a(0.75, 0.5).func_181675_d();
            vb.func_181662_b(octInWid, octInLen, 0.4).func_187315_a(0.75, 0.625).func_181675_d();
            vb.func_181662_b(-octInWid, octInLen, 0.4).func_187315_a(0.125, 0.625).func_181675_d();
            vb.func_181662_b(-octInWid, octInLen, -0.4).func_187315_a(0.125, 0.5).func_181675_d();
            vb.func_181662_b(-iconEdgeXRad, octInLen - 0.003, -0.4).func_187315_a(0.125, (double)this.getIconVSt(i)).func_181675_d();
            vb.func_181662_b(iconEdgeXRad, octInLen - 0.003, -0.4).func_187315_a(0.0, (double)this.getIconVSt(i)).func_181675_d();
            vb.func_181662_b(iconEdgeXRad, octInLen - 0.003, 0.4).func_187315_a(0.0, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(-iconEdgeXRad, octInLen - 0.003, 0.4).func_187315_a(0.125, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(0.078125, iconTop, 0.403).func_187315_a(0.125, (double)this.getIconVSt(i)).func_181675_d();
            vb.func_181662_b(-0.078125, iconTop, 0.403).func_187315_a(0.0, (double)this.getIconVSt(i)).func_181675_d();
            vb.func_181662_b(-0.078125, iconBottom, 0.403).func_187315_a(0.0, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(0.078125, iconBottom, 0.403).func_187315_a(0.125, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(0.078125, iconTop, -0.403).func_187315_a(0.0, (double)this.getIconVSt(i)).func_181675_d();
            vb.func_181662_b(0.078125, iconBottom, -0.403).func_187315_a(0.0, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(-0.078125, iconBottom, -0.403).func_187315_a(0.125, (double)this.getIconVEn(i)).func_181675_d();
            vb.func_181662_b(-0.078125, iconTop, -0.403).func_187315_a(0.125, (double)this.getIconVSt(i)).func_181675_d();
            tess.func_78381_a();
            GlStateManager.rotated((double)-45.0, (double)0.0, (double)0.0, (double)1.0);
        }
        if (linked) {
            GlStateManager.disableCull();
            int light = CRRenderUtil.getCurrLighting();
            CRRenderUtil.setBrightLighting();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            vb.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(octInWid, octInLen, 0.0).func_187315_a((double)0.926f, (double)portalVEn).func_181675_d();
            vb.func_181662_b(-octInWid, octInLen, 0.0).func_187315_a((double)0.824f, (double)portalVEn).func_181675_d();
            vb.func_181662_b(-octInLen, octInWid, 0.0).func_187315_a(0.75, (double)portalVMid2).func_181675_d();
            vb.func_181662_b(-octInLen, -octInWid, 0.0).func_187315_a(0.75, (double)portalVMid1).func_181675_d();
            vb.func_181662_b(-octInWid, -octInLen, 0.0).func_187315_a((double)0.824f, (double)portalVSt).func_181675_d();
            vb.func_181662_b(octInWid, -octInLen, 0.0).func_187315_a((double)0.926f, (double)portalVSt).func_181675_d();
            vb.func_181662_b(octInLen, -octInWid, 0.0).func_187315_a(1.0, (double)portalVMid1).func_181675_d();
            vb.func_181662_b(octInLen, octInWid, 0.0).func_187315_a(1.0, (double)portalVMid2).func_181675_d();
            tess.func_78381_a();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            CRRenderUtil.setLighting(light);
            GlStateManager.enableCull();
        }
        GlStateManager.popMatrix();
        for (i = 0; i < 4; ++i) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(1.0, 1.0, 0.5).func_187315_a(0.75, 0.0).func_181675_d();
            vb.func_181662_b(-1.0, 1.0, 0.5).func_187315_a(0.125, 0.0).func_181675_d();
            vb.func_181662_b(-0.6, 0.6, 0.5).func_187315_a(0.25, 0.125).func_181675_d();
            vb.func_181662_b(0.6, 0.6, 0.5).func_187315_a(0.625, 0.125).func_181675_d();
            vb.func_181662_b(1.0, 1.0, -0.5).func_187315_a(0.75, 0.0).func_181675_d();
            vb.func_181662_b(0.6, 0.6, -0.5).func_187315_a(0.625, 0.125).func_181675_d();
            vb.func_181662_b(-0.6, 0.6, -0.5).func_187315_a(0.25, 0.125).func_181675_d();
            vb.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(0.125, 0.0).func_181675_d();
            vb.func_181662_b(1.0, 1.0, -0.5).func_187315_a(0.75, 0.25).func_181675_d();
            vb.func_181662_b(-1.0, 1.0, -0.5).func_187315_a(0.125, 0.25).func_181675_d();
            vb.func_181662_b(-1.0, 1.0, 0.5).func_187315_a(0.125, 0.375).func_181675_d();
            vb.func_181662_b(1.0, 1.0, 0.5).func_187315_a(0.75, 0.375).func_181675_d();
            vb.func_181662_b(0.6, 0.6, -0.5).func_187315_a(0.75, 0.125).func_181675_d();
            vb.func_181662_b(0.6, 0.6, 0.5).func_187315_a(0.75, 0.25).func_181675_d();
            vb.func_181662_b(-0.6, 0.6, 0.5).func_187315_a(0.125, 0.25).func_181675_d();
            vb.func_181662_b(-0.6, 0.6, -0.5).func_187315_a(0.125, 0.125).func_181675_d();
            tess.func_78381_a();
            GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
        }
        vb.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(0.2, 1.0, triDepth).func_187315_a(0.125, 1.0).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, triDepth).func_187315_a(0.375, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, triDepth).func_187315_a(0.25, 0.75).func_181675_d();
        vb.func_181662_b(0.2, 1.0, -triDepth).func_187315_a(0.125, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, -triDepth).func_187315_a(0.25, 0.75).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, -triDepth).func_187315_a(0.375, 1.0).func_181675_d();
        tess.func_78381_a();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(0.2, 1.0, triDepth).func_187315_a(0.375, 0.75).func_181675_d();
        vb.func_181662_b(0.2, 1.0, 0.5).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, 0.5).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, triDepth).func_187315_a(0.375, 1.0).func_181675_d();
        vb.func_181662_b(0.2, 1.0, -triDepth).func_187315_a(0.375, 0.75).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, -triDepth).func_187315_a(0.375, 1.0).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, -0.5).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(0.2, 1.0, -0.5).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(0.2, 1.0, triDepth).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(0.0, 0.6, triDepth).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, 0.5).func_187315_a(0.4375, 1.0).func_181675_d();
        vb.func_181662_b(0.2, 1.0, 0.5).func_187315_a(0.4375, 0.75).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, triDepth).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, 0.5).func_187315_a(0.4375, 0.75).func_181675_d();
        vb.func_181662_b(0.0, 0.6, 0.5).func_187315_a(0.4375, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, triDepth).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(0.2, 1.0, -triDepth).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(0.2, 1.0, -0.5).func_187315_a(0.4375, 0.75).func_181675_d();
        vb.func_181662_b(0.0, 0.6, -0.5).func_187315_a(0.4375, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, -triDepth).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, -triDepth).func_187315_a(0.40625, 0.75).func_181675_d();
        vb.func_181662_b(0.0, 0.6, -triDepth).func_187315_a(0.40625, 1.0).func_181675_d();
        vb.func_181662_b(0.0, 0.6, -0.5).func_187315_a(0.4375, 1.0).func_181675_d();
        vb.func_181662_b(-0.2, 1.0, -0.5).func_187315_a(0.4375, 0.75).func_181675_d();
        tess.func_78381_a();
        if (frame.chevrons[0] != null) {
            CRRenderUtil.setBrightLighting();
            GlStateManager.pushMatrix();
            GlStateManager.rotated((double)45.0, (double)0.0, (double)0.0, (double)1.0);
            for (i = 0; i < frame.chevrons.length && frame.chevrons[i] != null; ++i) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(-0.078125, iconDialTop, 0.503).func_187315_a(0.0, (double)this.getIconVSt(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(-0.078125, iconDialBottom, 0.503).func_187315_a(0.0, (double)this.getIconVEn(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(0.078125, iconDialBottom, 0.503).func_187315_a(0.125, (double)this.getIconVEn(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(0.078125, iconDialTop, 0.503).func_187315_a(0.125, (double)this.getIconVSt(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                tess.func_78381_a();
                GlStateManager.rotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
            }
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.rotated((double)-45.0, (double)0.0, (double)0.0, (double)1.0);
            for (i = 0; i < frame.chevrons.length && frame.chevrons[i] != null; ++i) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(-0.078125, iconDialTop, -0.503).func_187315_a(0.125, (double)this.getIconVSt(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(0.078125, iconDialTop, -0.503).func_187315_a(0.0, (double)this.getIconVSt(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(0.078125, iconDialBottom, -0.503).func_187315_a(0.0, (double)this.getIconVEn(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                vb.func_181662_b(-0.078125, iconDialBottom, -0.503).func_187315_a(0.125, (double)this.getIconVEn(GatewayAddress.getEntryID(frame.chevrons[i]))).func_181675_d();
                tess.func_78381_a();
                GlStateManager.rotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
            }
            GlStateManager.popMatrix();
        }
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }

    private float getIconVSt(int index) {
        return (float)index / 8.0f;
    }

    private float getIconVEn(int index) {
        return (float)(index + 1) / 8.0f;
    }

    public boolean isGlobalRenderer(GatewayFrameTileEntity te) {
        return te.isActive();
    }
}

