/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.technomancy.HamsterWheelTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HamsterWheelRenderer
extends TileEntityRenderer<HamsterWheelTileEntity> {
    private static final ResourceLocation textureHam = new ResourceLocation("crossroads", "textures/model/hamster.png");

    public void render(HamsterWheelTileEntity wheel, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockPos pos;
        World world = wheel.func_145831_w();
        if (!world.func_175667_e(pos = wheel.func_174877_v()) || world.func_180495_p(pos).func_177230_c() != CRBlocks.hamsterWheel) {
            return;
        }
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)CRProperties.HORIZ_FACING);
        GlStateManager.pushMatrix();
        GlStateManager.pushLightingAttributes();
        GlStateManager.disableLighting();
        GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.rotated((double)(-facing.func_185119_l() + 180.0f), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        float angle = wheel.nextAngle - wheel.angle;
        angle *= partialTicks;
        angle += wheel.angle;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)-0.2, (double)-0.25, (double)0.3);
        float peakAngle = 60.0f;
        float degreesPerCycle = 50.0f;
        float feetAngle = Math.abs(4.0f * peakAngle * Math.abs(angle *= (float)(-facing.func_176743_c().func_179524_a())) / degreesPerCycle % (4.0f * peakAngle) - 2.0f * peakAngle) - peakAngle;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)(j == 0 ? 0.0 : 0.4), (double)(i == 0 ? -0.065 : 0.065), (double)0.0);
                GlStateManager.scaled((double)0.4, (double)0.07, (double)0.49);
                GlStateManager.rotated((double)(i + j % 2 == 0 ? (double)feetAngle : (double)(-feetAngle)), (double)0.0, (double)1.0, (double)0.0);
                CRModels.drawAxle(textureHam, textureHam, Color.LIGHT_GRAY);
                GlStateManager.popMatrix();
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.rotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.4375, (double)0.0);
        GlStateManager.scaled((double)1.0, (double)0.8, (double)1.0);
        GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        CRModels.drawAxle(GearFactory.findMaterial("iron").getColor());
        GlStateManager.popMatrix();
        float lHalf = 0.375f;
        for (int i = 0; i < 8; ++i) {
            GlStateManager.pushMatrix();
            GlStateManager.rotated((double)(45.0f * (float)i), (double)0.0, (double)1.0, (double)0.0);
            GlStateManager.translated((double)lHalf, (double)-0.25, (double)0.0);
            GlStateManager.scaled((double)0.41, (double)(i % 2 == 0 ? 0.5 : 0.45), (double)(7.5 * (double)lHalf));
            CRModels.drawAxle(Color.GRAY);
            GlStateManager.popMatrix();
        }
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        GlStateManager.enableLighting();
        GlStateManager.popAttributes();
        GlStateManager.popMatrix();
    }
}

