/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.blocks.rotary.RotaryDrill;
import com.Da_Technomancer.crossroads.tileentities.rotary.RotaryDrillTileEntity;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;

public class RotaryDrillRenderer
extends TileEntityRenderer<RotaryDrillTileEntity> {
    private static final ResourceLocation TEXTURE_DRILL = new ResourceLocation("textures/block/iron_block.png");

    public void render(RotaryDrillTileEntity drill, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!drill.func_145831_w().func_175667_e(drill.func_174877_v())) {
            return;
        }
        BlockState state = drill.func_145831_w().func_180495_p(drill.func_174877_v());
        LazyOptional<IAxleHandler> axle = drill.getCapability(Capabilities.AXLE_CAPABILITY, null);
        if (!(state.func_177230_c() instanceof RotaryDrill) || !axle.isPresent()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.disableLighting();
        Direction dir = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        if (dir == Direction.DOWN) {
            GlStateManager.rotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        } else if (dir != Direction.UP) {
            GlStateManager.rotated((double)(-dir.func_185119_l()), (double)0.0, (double)1.0, (double)0.0);
            GlStateManager.rotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        }
        GlStateManager.rotated((double)(((IAxleHandler)axle.orElseThrow(NullPointerException::new)).getAngle(partialTicks) * (float)dir.func_176743_c().func_179524_a()), (double)0.0, (double)1.0, (double)0.0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_DRILL);
        if (drill.isGolden()) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)0.15f);
        }
        BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RotaryDrillRenderer.renderLayer(vb, -8.0f, 10.0f);
        RotaryDrillRenderer.renderLayer(vb, -2.0f, 6.0f);
        RotaryDrillRenderer.renderLayer(vb, 4.0f, 2.0f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.pushMatrix();
        GlStateManager.rotated((double)45.0, (double)0.0, (double)1.0, (double)0.0);
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        RotaryDrillRenderer.renderLayer(vb, -5.0f, 8.0f);
        RotaryDrillRenderer.renderLayer(vb, 1.0f, 4.0f);
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.popMatrix();
        if (drill.isGolden()) {
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
    }

    private static void renderLayer(BufferBuilder vb, float bottom, float width) {
        float height = 0.1875f;
        float top = (bottom /= 16.0f) + height;
        float start = -(width /= 16.0f) / 2.0f;
        float end = width / 2.0f;
        vb.func_181662_b((double)start, (double)top, (double)start).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)top, (double)end).func_187315_a(0.0, (double)width).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)end).func_187315_a((double)width, (double)width).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)start).func_187315_a((double)width, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)start).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)start).func_187315_a((double)width, 0.0).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)end).func_187315_a((double)width, (double)width).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)end).func_187315_a(0.0, (double)width).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)start).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)top, (double)start).func_187315_a(0.0, (double)height).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)start).func_187315_a((double)width, (double)height).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)start).func_187315_a((double)width, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)end).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)end).func_187315_a((double)width, 0.0).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)end).func_187315_a((double)width, (double)height).func_181675_d();
        vb.func_181662_b((double)start, (double)top, (double)end).func_187315_a(0.0, (double)height).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)end).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)top, (double)end).func_187315_a((double)height, 0.0).func_181675_d();
        vb.func_181662_b((double)start, (double)top, (double)start).func_187315_a((double)height, (double)width).func_181675_d();
        vb.func_181662_b((double)start, (double)bottom, (double)start).func_187315_a(0.0, (double)width).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)end).func_187315_a(0.0, 0.0).func_181675_d();
        vb.func_181662_b((double)end, (double)bottom, (double)start).func_187315_a(0.0, (double)width).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)start).func_187315_a((double)height, (double)width).func_181675_d();
        vb.func_181662_b((double)end, (double)top, (double)end).func_187315_a((double)height, 0.0).func_181675_d();
    }
}

