/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class AlchemicalTubeTileEntity
extends AlchemyCarrierTE
implements ConduitBlock.IConduitTE<EnumTransferMode> {
    @ObjectHolder(value="alchemical_tube")
    private static TileEntityType<AlchemicalTubeTileEntity> type = null;
    protected boolean[] matches = new boolean[6];
    protected EnumTransferMode[] modes = ConduitBlock.IConduitTE.genModeArray(EnumTransferMode.INPUT);

    public AlchemicalTubeTileEntity() {
        this((TileEntityType<? extends AlchemicalTubeTileEntity>)type);
    }

    protected AlchemicalTubeTileEntity(TileEntityType<? extends AlchemicalTubeTileEntity> type) {
        super(type);
    }

    public AlchemicalTubeTileEntity(boolean glass) {
        this((TileEntityType<? extends AlchemicalTubeTileEntity>)type, glass);
    }

    protected AlchemicalTubeTileEntity(TileEntityType<? extends AlchemicalTubeTileEntity> type, boolean glass) {
        super(type, glass);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.chemOpt.invalidate();
        this.chemOpt = LazyOptional.of(() -> this.handler);
    }

    @Override
    public EnumTransferMode[] getModes() {
        return this.modes;
    }

    @Override
    @Nonnull
    public EnumTransferMode deserialize(String name) {
        return ConduitBlock.IConduitTE.deserializeEnumMode(name);
    }

    @Override
    public boolean hasMatch(int side, EnumTransferMode mode) {
        LazyOptional otherOpt;
        Direction face = Direction.func_82600_a((int)side);
        TileEntity neighTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        return neighTE != null && (otherOpt = neighTE.getCapability(Capabilities.CHEMICAL_CAPABILITY, face.func_176734_d())).isPresent() && ((IChemicalHandler)otherOpt.orElseThrow(NoSuchFieldError::new)).getChannel(face.func_176734_d()).connectsWith(this.glass ? EnumContainerType.GLASS : EnumContainerType.CRYSTAL);
    }

    @Override
    @Nonnull
    public boolean[] getHasMatch() {
        return this.matches;
    }

    @Override
    protected void performTransfer() {
        EnumTransferMode[] modes = this.getModes();
        for (int i = 0; i < 6; ++i) {
            IChemicalHandler otherHandler;
            LazyOptional otherOpt;
            Direction side = Direction.func_82600_a((int)i);
            if (!modes[i].isConnection()) continue;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (te != null && (otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent() && (otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new)).getChannel(side.func_176734_d()).connectsWith(this.glass ? EnumContainerType.GLASS : EnumContainerType.CRYSTAL)) {
                this.setData(i, true, (Comparable)((Object)modes[i]));
                if (this.contents.getTotalQty() == 0 || modes[i] != EnumTransferMode.OUTPUT || !otherHandler.insertReagents(this.contents, side.func_176734_d(), this.handler)) continue;
                this.correctReag();
                this.func_70296_d();
                continue;
            }
            this.setData(i, false, (Comparable)((Object)modes[i]));
        }
    }

    protected boolean allowConnect(Direction side) {
        return side == null || this.modes[side.func_176745_a()].isConnection();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ConduitBlock.IConduitTE.writeConduitNBT(nbt, this);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        ConduitBlock.IConduitTE.readConduitNBT(nbt, this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY && this.allowConnect(side)) {
            return this.chemOpt;
        }
        return super.getCapability(cap, side);
    }
}

