/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.alchemy.AtmosChargeSavedData;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.blocks.alchemy.AtmosCharger;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class AtmosChargerTileEntity
extends TileEntity
implements ITickableTileEntity,
IInfoTE {
    @ObjectHolder(value="atmos_charger")
    private static TileEntityType<AtmosChargerTileEntity> type = null;
    private static final Tag<Block> ANTENNA_TAG = new BlockTags.Wrapper(new ResourceLocation("crossroads", "atmos_antenna"));
    private static final int FE_CAPACITY = 20000;
    private int fe = 0;
    private int renderTimer = 0;
    private Boolean mode = null;
    private LazyOptional<IEnergyStorage> feOpt = LazyOptional.of(() -> new ElecHandler());

    public AtmosChargerTileEntity() {
        super(type);
    }

    public void resetCache() {
        this.mode = null;
    }

    private boolean isExtractMode() {
        if (this.mode != null) {
            return this.mode;
        }
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() != CRBlocks.atmosCharger) {
            return false;
        }
        this.mode = (Boolean)state.func_177229_b((IProperty)CRProperties.ACTIVE);
        return this.mode;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        if (player.field_70170_p instanceof ServerWorld) {
            int charge = AtmosChargeSavedData.getCharge((ServerWorld)player.field_70170_p);
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.atmos_charger.reading", new Object[]{charge, AtmosChargeSavedData.getCapacity(), MiscUtil.preciseRound(100.0 * (double)charge / (double)AtmosChargeSavedData.getCapacity(), 1)}));
        }
    }

    private boolean isValidStructure() {
        BlockPos checkPos = this.field_174879_c;
        for (int i = 0; i < 4; ++i) {
            if (this.field_145850_b.func_180495_p(checkPos = checkPos.func_177984_a()).func_203425_a(ANTENNA_TAG)) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (this.field_145850_b.field_72995_K || !(state.func_177230_c() instanceof AtmosCharger)) {
            return;
        }
        --this.renderTimer;
        int atmosCharge = AtmosChargeSavedData.getCharge((ServerWorld)this.field_145850_b);
        if (this.isExtractMode()) {
            int op = Math.min((20000 - this.fe) / 1000, atmosCharge / 1000);
            if (op != 0 && this.isValidStructure()) {
                this.fe += op * 1000;
                AtmosChargeSavedData.setCharge((ServerWorld)this.field_145850_b, atmosCharge -= op * 1000);
                this.func_70296_d();
                this.renderArc(false);
            }
            if (this.fe > 0) {
                for (int i = 0; i < 4; ++i) {
                    int moved;
                    LazyOptional otherCap;
                    Direction side = Direction.func_176731_b((int)i);
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
                    if (te == null || !(otherCap = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d())).isPresent() || (moved = ((IEnergyStorage)otherCap.orElseThrow(NullPointerException::new)).receiveEnergy(this.fe, false)) <= 0) continue;
                    this.fe -= moved;
                    this.func_70296_d();
                }
            }
        } else {
            int op = Math.min(this.fe / 1000, (AtmosChargeSavedData.getCapacity() - atmosCharge) / 1000);
            if (op != 0 && this.isValidStructure()) {
                this.fe -= op * 1000;
                AtmosChargeSavedData.setCharge((ServerWorld)this.field_145850_b, atmosCharge += op * 1000);
                this.func_70296_d();
                this.renderArc(true);
            }
        }
    }

    private void renderArc(boolean up) {
        if (this.renderTimer <= 0) {
            this.renderTimer = 10;
            int arcs = this.field_145850_b.field_73012_v.nextInt(4) + 2;
            float angle = (float)Math.PI * 2 / (float)arcs;
            float[] start = new float[]{(float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.1f, (float)this.field_174879_c.func_177952_p() + 0.5f};
            float[] startEn = new float[]{start[0], (float)this.field_174879_c.func_177956_o() + 4.75f, start[2]};
            if (!up) {
                float swap = start[1];
                start[1] = startEn[1];
                startEn[1] = swap;
            }
            Vec3d arcVec = CRRenderUtil.VEC_K.func_186678_a(1.4);
            int color = TeslaCoilTopTileEntity.COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)];
            for (int i = 0; i < arcs; ++i) {
                arcVec = arcVec.func_178785_b(angle);
                CRRenderUtil.addArc(this.field_145850_b, start[0], start[1], start[2], start[0] + (float)arcVec.field_72450_a, start[1] + (float)arcVec.field_72448_b, start[2] + (float)arcVec.field_72449_c, startEn[0], startEn[1], startEn[2], 1, 0.0f, (byte)20, color);
            }
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.fe = nbt.func_74762_e("fe");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fe", this.fe);
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.feOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side != Direction.UP) {
            return this.feOpt;
        }
        return super.getCapability(cap, side);
    }

    private class ElecHandler
    implements IEnergyStorage {
        private ElecHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (AtmosChargerTileEntity.this.isExtractMode()) {
                return 0;
            }
            int toMove = Math.min(20000 - AtmosChargerTileEntity.this.fe, maxReceive);
            if (!simulate && toMove > 0) {
                AtmosChargerTileEntity.this.fe += toMove;
                AtmosChargerTileEntity.this.func_70296_d();
            }
            return toMove;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!AtmosChargerTileEntity.this.isExtractMode()) {
                return 0;
            }
            int toMove = Math.min(maxExtract, AtmosChargerTileEntity.this.fe);
            if (!simulate) {
                AtmosChargerTileEntity.this.fe -= toMove;
                AtmosChargerTileEntity.this.func_70296_d();
            }
            return toMove;
        }

        public int getEnergyStored() {
            return AtmosChargerTileEntity.this.fe;
        }

        public int getMaxEnergyStored() {
            return 20000;
        }

        public boolean canExtract() {
            return AtmosChargerTileEntity.this.isExtractMode();
        }

        public boolean canReceive() {
            return !AtmosChargerTileEntity.this.isExtractMode();
        }
    }
}

