/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.tileentities.alchemy.HeatLimiterBasicTileEntity;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import com.Da_Technomancer.essentials.blocks.ESBlocks;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.TickPriority;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatLimiterRedstoneTileEntity
extends HeatLimiterBasicTileEntity {
    @ObjectHolder(value="heat_limiter")
    private static TileEntityType<HeatLimiterRedstoneTileEntity> type = null;
    private int redstone;
    private float circRedstone;
    private LazyOptional<IRedstoneHandler> redsOpt = LazyOptional.of(() -> new CircHandler());
    private WeakReference<LazyOptional<IRedstoneHandler>> redsRef = new WeakReference<LazyOptional<IRedstoneHandler>>(this.redsOpt);
    private ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> sources = new ArrayList(1);
    private boolean builtConnections = false;

    public HeatLimiterRedstoneTileEntity() {
        super(type);
    }

    @Override
    public double getSetting() {
        if (!this.builtConnections) {
            this.buildConnections();
        }
        return Math.max((float)this.redstone, this.circRedstone);
    }

    public void setRedstone(int redstone) {
        if (this.redstone != redstone) {
            this.redstone = redstone;
            this.func_70296_d();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("reds", this.redstone);
        nbt.func_74776_a("circ_reds", this.circRedstone);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.redstone = nbt.func_74762_e("reds");
        this.circRedstone = nbt.func_74760_g("circ_reds");
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.redsOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.redsOpt;
        }
        return super.getCapability(cap, dir);
    }

    public void buildConnections() {
        if (!this.field_145850_b.field_72995_K) {
            this.builtConnections = true;
            ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>> preSrc = new ArrayList<WeakReference<LazyOptional<IRedstoneHandler>>>(this.sources.size());
            preSrc.addAll(this.sources);
            this.sources.clear();
            for (Direction checkDir : Direction.values()) {
                IRedstoneHandler otherHandler;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(checkDir));
                if (te == null || (otherHandler = (IRedstoneHandler)BlockUtil.get((LazyOptional)te.getCapability(RedstoneUtil.REDSTONE_CAPABILITY, checkDir.func_176734_d()))) == null) continue;
                otherHandler.requestSrc(this.redsRef, 0, checkDir.func_176734_d(), checkDir);
            }
            if (this.sources.size() != preSrc.size() || !this.sources.containsAll(preSrc)) {
                this.field_145850_b.func_205220_G_().func_205362_a(this.field_174879_c, (Object)ESBlocks.redstoneTransmitter, 2, TickPriority.NORMAL);
            }
        }
    }

    private class CircHandler
    implements IRedstoneHandler {
        private CircHandler() {
        }

        public float getOutput() {
            return 0.0f;
        }

        public void findDependents(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, int i, Direction fromSide, Direction nominalSide) {
            LazyOptional srcOption = (LazyOptional)weakReference.get();
            if (srcOption != null && srcOption.isPresent()) {
                IRedstoneHandler srcHandler = (IRedstoneHandler)BlockUtil.get((LazyOptional)srcOption);
                srcHandler.addDependent(HeatLimiterRedstoneTileEntity.this.redsRef, nominalSide);
                if (!HeatLimiterRedstoneTileEntity.this.sources.contains(weakReference)) {
                    HeatLimiterRedstoneTileEntity.this.sources.add(weakReference);
                }
            }
        }

        public void requestSrc(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, int i, Direction direction, Direction direction1) {
        }

        public void addSrc(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, Direction direction) {
            if (!HeatLimiterRedstoneTileEntity.this.sources.contains(weakReference)) {
                HeatLimiterRedstoneTileEntity.this.sources.add(weakReference);
                this.notifyInputChange(weakReference);
            }
        }

        public void addDependent(WeakReference<LazyOptional<IRedstoneHandler>> weakReference, Direction direction) {
        }

        public void notifyInputChange(WeakReference<LazyOptional<IRedstoneHandler>> weakReference) {
            float prevCirc = HeatLimiterRedstoneTileEntity.this.circRedstone;
            HeatLimiterRedstoneTileEntity.this.circRedstone = 0.0f;
            for (int i = 0; i < HeatLimiterRedstoneTileEntity.this.sources.size(); ++i) {
                WeakReference src = (WeakReference)HeatLimiterRedstoneTileEntity.this.sources.get(i);
                LazyOptional srcOpt = (LazyOptional)src.get();
                if (srcOpt != null && srcOpt.isPresent()) {
                    HeatLimiterRedstoneTileEntity.this.circRedstone = Math.max(HeatLimiterRedstoneTileEntity.this.circRedstone, (float)Math.round(RedstoneUtil.sanitize((float)((IRedstoneHandler)srcOpt.orElseThrow(NullPointerException::new)).getOutput())));
                    continue;
                }
                HeatLimiterRedstoneTileEntity.this.sources.remove(i);
                --i;
            }
            if (HeatLimiterRedstoneTileEntity.this.circRedstone != prevCirc) {
                HeatLimiterRedstoneTileEntity.this.func_70296_d();
            }
        }
    }
}

