/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatedTubeTileEntity
extends AlchemyCarrierTE {
    @ObjectHolder(value="heated_tube")
    private static TileEntityType<HeatedTubeTileEntity> type = null;
    private final LazyOptional<IHeatHandler> heatOpt = LazyOptional.of(() -> new HeatHandler());

    public HeatedTubeTileEntity() {
        super(type);
    }

    public HeatedTubeTileEntity(boolean glass) {
        super(type, glass);
    }

    @Override
    protected boolean useCableHeat() {
        return true;
    }

    @Override
    protected void initHeat() {
        if (!this.init) {
            this.init = true;
            this.cableTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected EnumTransferMode[] getModes() {
        EnumTransferMode[] output = new EnumTransferMode[]{EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE};
        Direction outSide = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CRProperties.HORIZ_FACING);
        output[outSide.func_176745_a()] = EnumTransferMode.OUTPUT;
        output[outSide.func_176734_d().func_176745_a()] = EnumTransferMode.INPUT;
        return output;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.heatOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY && (side == null || side.func_176740_k() == ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)CRProperties.HORIZ_FACING)).func_176740_k())) {
            return this.chemOpt;
        }
        if (cap == Capabilities.HEAT_CAPABILITY && (side == null || side.func_176740_k() == Direction.Axis.Y)) {
            return this.heatOpt;
        }
        return super.getCapability(cap, side);
    }

    private class HeatHandler
    implements IHeatHandler {
        private HeatHandler() {
        }

        @Override
        public double getTemp() {
            HeatedTubeTileEntity.this.initHeat();
            return HeatedTubeTileEntity.this.cableTemp;
        }

        @Override
        public void setTemp(double tempIn) {
            HeatedTubeTileEntity.this.init = true;
            HeatedTubeTileEntity.this.cableTemp = tempIn;
            HeatedTubeTileEntity.this.dirtyReag = true;
            HeatedTubeTileEntity.this.func_70296_d();
        }

        @Override
        public void addHeat(double tempChange) {
            HeatedTubeTileEntity.this.initHeat();
            HeatedTubeTileEntity.this.cableTemp += tempChange;
            HeatedTubeTileEntity.this.dirtyReag = true;
            HeatedTubeTileEntity.this.func_70296_d();
        }
    }
}

