/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class MaxwellDemonTileEntity
extends TileEntity
implements ITickableTileEntity,
IInfoTE {
    @ObjectHolder(value="maxwell_demon")
    private static TileEntityType<MaxwellDemonTileEntity> type = null;
    public static final double MAX_TEMP = 2500.0;
    public static final double MIN_TEMP = -250.0;
    public static final double RATE = 5.0;
    private double tempUp = 0.0;
    private double tempDown = 0.0;
    private boolean init = false;
    private final LazyOptional<IHeatHandler> heatOptUp = LazyOptional.of(() -> new HeatHandler(true));
    private final LazyOptional<IHeatHandler> heatOptDown = LazyOptional.of(() -> new HeatHandler(false));

    public MaxwellDemonTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.maxwell_demon.read_top", new Object[]{CRConfig.formatVal(this.tempUp)}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.maxwell_demon.read_bottom", new Object[]{CRConfig.formatVal(this.tempDown)}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.maxwell_demon.read_biome", new Object[]{CRConfig.formatVal(HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c))}));
    }

    private void init() {
        if (!this.init) {
            this.tempDown = this.tempUp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
            this.init = true;
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.init();
        if (this.tempUp < 2500.0) {
            this.tempUp = Math.min(2500.0, this.tempUp + 5.0);
            this.func_70296_d();
        }
        if (this.tempDown > -250.0) {
            this.tempDown = Math.max(-250.0, this.tempDown - 5.0);
            this.func_70296_d();
        }
        for (int i = 0; i < 2; ++i) {
            double reservePool;
            LazyOptional heatOpt;
            Direction dir = Direction.func_82600_a((int)i);
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            if (te == null || !(heatOpt = te.getCapability(Capabilities.HEAT_CAPABILITY, dir.func_176734_d())).isPresent()) continue;
            double d = reservePool = i == 0 ? this.tempDown : this.tempUp;
            if (i == 0) {
                this.tempDown -= reservePool;
            } else {
                this.tempUp -= reservePool;
            }
            IHeatHandler handler = (IHeatHandler)heatOpt.orElseThrow(NullPointerException::new);
            reservePool += handler.getTemp();
            handler.addHeat(-handler.getTemp());
            reservePool /= 2.0;
            if (i == 0) {
                this.tempDown += reservePool;
            } else {
                this.tempUp += reservePool;
            }
            handler.addHeat(reservePool);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("init_heat", this.init);
        nbt.func_74780_a("temp_u", this.tempUp);
        nbt.func_74780_a("temp_d", this.tempDown);
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.init = nbt.func_74767_n("init_heat");
        this.tempUp = nbt.func_74769_h("temp_u");
        this.tempDown = nbt.func_74769_h("temp_d");
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.heatOptUp.invalidate();
        this.heatOptDown.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.HEAT_CAPABILITY) {
            if (side == null || side == Direction.UP) {
                return this.heatOptUp;
            }
            if (side == Direction.DOWN) {
                return this.heatOptDown;
            }
        }
        return super.getCapability(cap, side);
    }

    private class HeatHandler
    implements IHeatHandler {
        private final boolean up;

        private HeatHandler(boolean up) {
            this.up = up;
        }

        @Override
        public double getTemp() {
            MaxwellDemonTileEntity.this.init();
            return this.up ? MaxwellDemonTileEntity.this.tempUp : MaxwellDemonTileEntity.this.tempDown;
        }

        @Override
        public void setTemp(double tempIn) {
            MaxwellDemonTileEntity.this.init = true;
            if (this.up) {
                MaxwellDemonTileEntity.this.tempUp = tempIn;
            } else {
                MaxwellDemonTileEntity.this.tempDown = tempIn;
            }
            MaxwellDemonTileEntity.this.func_70296_d();
        }

        @Override
        public void addHeat(double heat) {
            MaxwellDemonTileEntity.this.init();
            if (this.up) {
                MaxwellDemonTileEntity.this.tempUp += heat;
            } else {
                MaxwellDemonTileEntity.this.tempDown += heat;
            }
            MaxwellDemonTileEntity.this.func_70296_d();
        }
    }
}

