/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class BeamRedirectorTileEntity
extends BeamRenderTE {
    @ObjectHolder(value="beam_redirector")
    private static TileEntityType<BeamRedirectorTileEntity> type = null;
    private boolean redstone;
    private Direction dir = null;

    public BeamRedirectorTileEntity() {
        super(type);
    }

    private Direction getDir() {
        if (this.dir == null) {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != CRBlocks.beamRedirector) {
                return Direction.NORTH;
            }
            this.dir = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        }
        return this.dir;
    }

    public void setRedstone(boolean redstone) {
        if (this.redstone != redstone) {
            this.redstone = redstone;
            this.func_70296_d();
        }
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.dir = null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("reds", this.redstone);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.redstone = nbt.func_74767_n("reds");
    }

    @Override
    protected void doEmit(BeamUnit out) {
        Direction facing = this.getDir();
        boolean reds = this.redstone;
        if (this.beamer[facing.func_176745_a()].emit(reds ? out : BeamUnit.EMPTY, this.field_145850_b)) {
            this.refreshBeam(facing.func_176745_a());
        }
        if (this.beamer[facing.func_176734_d().func_176745_a()].emit(reds ? BeamUnit.EMPTY : out, this.field_145850_b)) {
            this.refreshBeam(facing.func_176734_d().func_176745_a());
        }
    }

    @Override
    protected boolean[] inputSides() {
        boolean[] input = new boolean[]{true, true, true, true, true, true};
        Direction facing = this.getDir();
        input[facing.func_176745_a()] = false;
        input[facing.func_176734_d().func_176745_a()] = false;
        return input;
    }

    @Override
    protected boolean[] outputSides() {
        boolean[] output = new boolean[6];
        Direction facing = this.getDir();
        output[facing.func_176745_a()] = true;
        output[facing.func_176734_d().func_176745_a()] = true;
        return output;
    }
}

