/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.tileentities.rotary.MasterAxisTileEntity;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class CrystalMasterAxisTileEntity
extends MasterAxisTileEntity
implements IInfoTE {
    @ObjectHolder(value="crystal_master_axis")
    private static TileEntityType<CrystalMasterAxisTileEntity> type = null;
    private double lastSumEnergy;
    private EnumBeamAlignments currentElement;
    private int time;
    private final LazyOptional<IBeamHandler> magicOpt = LazyOptional.of(() -> new BeamHandler());

    public CrystalMasterAxisTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.crystal_master_axis.info", new Object[]{this.currentElement == null ? MiscUtil.localize("alignment.none") : this.currentElement.getLocalName(this.time < 0), Math.abs(this.time)}));
    }

    public int getTime() {
        return this.time;
    }

    @Override
    protected void runCalc() {
        double sumIRot = 0.0;
        this.sumEnergy = 0.0;
        for (IAxleHandler gear : this.rotaryMembers) {
            sumIRot += gear.getMoInertia() * Math.pow(gear.getRotationRatio(), 2.0);
        }
        if (sumIRot == 0.0 || sumIRot != sumIRot) {
            return;
        }
        if (this.currentElement == EnumBeamAlignments.STABILITY) {
            for (IAxleHandler gear : this.rotaryMembers) {
                this.sumEnergy += Math.signum(gear.getRotationRatio()) * gear.getMotionData()[1];
            }
        } else {
            this.sumEnergy = RotaryUtil.getTotalEnergy(this.rotaryMembers);
            if (this.currentElement == EnumBeamAlignments.ENERGY) {
                this.sumEnergy += (Double)CRConfig.crystalAxisMult.get() * (Math.signum(this.sumEnergy) == 0.0 ? 1.0 : Math.signum(this.sumEnergy));
            } else if (this.currentElement == EnumBeamAlignments.CHARGE) {
                this.sumEnergy += ((Double)CRConfig.crystalAxisMult.get()).doubleValue();
            } else if (this.currentElement == EnumBeamAlignments.EQUILIBRIUM) {
                this.sumEnergy = (this.sumEnergy + 9.0 * this.lastSumEnergy) / 10.0;
            }
        }
        if (this.sumEnergy < 1.0 && this.sumEnergy > -1.0) {
            this.sumEnergy = 0.0;
        }
        this.lastSumEnergy = this.sumEnergy;
        for (IAxleHandler gear : this.rotaryMembers) {
            double newEnergy;
            gear.getMotionData()[0] = Math.signum(this.sumEnergy) * Math.signum(gear.getRotationRatio()) * Math.sqrt(Math.abs(this.sumEnergy) * 2.0 * Math.pow(gear.getRotationRatio(), 2.0) / sumIRot);
            gear.getMotionData()[1] = newEnergy = Math.signum(gear.getMotionData()[0]) * Math.pow(gear.getMotionData()[0], 2.0) * gear.getMoInertia() / 2.0;
            gear.getMotionData()[2] = (newEnergy - gear.getMotionData()[3]) * 20.0;
            gear.getMotionData()[3] = newEnergy;
            gear.markChanged();
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("time", this.time);
        if (this.currentElement != null) {
            nbt.func_74778_a("elem", this.currentElement.name());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.time = nbt.func_74762_e("time");
        this.currentElement = nbt.func_74764_b("elem") ? EnumBeamAlignments.valueOf(nbt.func_74779_i("elem")) : null;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.currentElement != null && this.time-- <= 0) {
            this.currentElement = null;
            this.time = 0;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.magicOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.BEAM_CAPABILITY && side != this.getFacing()) {
            return this.magicOpt;
        }
        return super.getCapability(cap, side);
    }

    public int getRedstone() {
        return this.time;
    }

    private class BeamHandler
    implements IBeamHandler {
        private BeamHandler() {
        }

        @Override
        public void setBeam(BeamUnit mag) {
            if (!mag.isEmpty()) {
                EnumBeamAlignments newElem = EnumBeamAlignments.getAlignment(mag);
                if (newElem != CrystalMasterAxisTileEntity.this.currentElement) {
                    CrystalMasterAxisTileEntity.this.currentElement = newElem;
                    if (mag.getVoid() == 0) {
                        CrystalMasterAxisTileEntity.this.time = mag.getPower() * 4;
                    }
                } else {
                    CrystalMasterAxisTileEntity.this.time = Math.max(mag.getVoid() == 0 ? CrystalMasterAxisTileEntity.this.time + mag.getPower() * 4 : CrystalMasterAxisTileEntity.this.time - mag.getPower() * 4, 0);
                }
            }
        }
    }
}

