/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamManager;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.IIntReceiver;
import com.Da_Technomancer.crossroads.API.packets.SendIntToClient;
import com.Da_Technomancer.crossroads.API.templates.IBeamRenderTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import com.Da_Technomancer.crossroads.items.itemSets.OreSetup;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class LensFrameTileEntity
extends TileEntity
implements IBeamRenderTE,
IIntReceiver {
    @ObjectHolder(value="lens_frame")
    private static TileEntityType<LensFrameTileEntity> type = null;
    private int packetNeg;
    private int packetPos;
    private int contents = 0;
    private Direction.Axis axis = null;
    private BeamUnit prevMag = BeamUnit.EMPTY;
    private int lastRedstone;
    private BeamManager[] beamer = new BeamManager[2];
    private LazyOptional<IBeamHandler> magicOpt = LazyOptional.of(() -> new BeamHandler(Direction.AxisDirection.NEGATIVE));
    private LazyOptional<IBeamHandler> magicOptNeg = LazyOptional.of(() -> new BeamHandler(Direction.AxisDirection.POSITIVE));
    private final LazyOptional<IItemHandler> lensOpt = LazyOptional.of(() -> new LensHandler());

    public LensFrameTileEntity() {
        super(type);
    }

    private Direction.Axis getAxis() {
        if (this.axis == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != CRBlocks.lensFrame) {
                return Direction.Axis.X;
            }
            this.axis = (Direction.Axis)state.func_177229_b((IProperty)ESProperties.AXIS);
        }
        return this.axis;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public ItemStack getItem() {
        switch (this.contents) {
            case 1: {
                return new ItemStack((IItemProvider)OreSetup.gemRuby, 1);
            }
            case 2: {
                return new ItemStack((IItemProvider)Items.field_151166_bC, 1);
            }
            case 3: {
                return new ItemStack((IItemProvider)Items.field_151045_i, 1);
            }
            case 4: {
                return new ItemStack((IItemProvider)CRItems.pureQuartz, 1);
            }
            case 5: {
                return new ItemStack((IItemProvider)CRItems.brightQuartz, 1);
            }
            case 6: {
                return new ItemStack((IItemProvider)OreSetup.voidCrystal, 1);
            }
        }
        return ItemStack.field_190927_a;
    }

    public int getIDFromItem(ItemStack stack) {
        if (CRItemTags.GEMS_RUBY.func_199685_a_((Object)stack.func_77973_b())) {
            return 1;
        }
        if (Tags.Items.GEMS_EMERALD.func_199685_a_((Object)stack.func_77973_b())) {
            return 2;
        }
        if (Tags.Items.GEMS_DIAMOND.func_199685_a_((Object)stack.func_77973_b())) {
            return 3;
        }
        if (stack.func_77973_b() == CRItems.pureQuartz) {
            return 4;
        }
        if (stack.func_77973_b() == CRItems.brightQuartz) {
            return 5;
        }
        if (stack.func_77973_b() == OreSetup.voidCrystal) {
            return 6;
        }
        return 0;
    }

    public void setContents(int id) {
        this.contents = id;
        this.func_70296_d();
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendIntToClient(2, this.contents, this.field_174879_c));
    }

    public int getContents() {
        return this.contents;
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.beamer[1] != null && this.field_145850_b != null) {
            this.beamer[1].emit(BeamUnit.EMPTY, this.field_145850_b);
            this.refreshBeam(true);
        }
        if (this.beamer[0] != null && this.field_145850_b != null) {
            this.beamer[0].emit(BeamUnit.EMPTY, this.field_145850_b);
            this.refreshBeam(false);
        }
        this.axis = null;
        this.magicOpt.invalidate();
        this.magicOptNeg.invalidate();
        this.magicOpt = LazyOptional.of(() -> new BeamHandler(Direction.AxisDirection.NEGATIVE));
        this.magicOptNeg = LazyOptional.of(() -> new BeamHandler(Direction.AxisDirection.POSITIVE));
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendIntToClient(3, 0, this.field_174879_c));
        }
    }

    private void refreshBeam(boolean positive) {
        int index = positive ? 1 : 0;
        int packet = this.beamer[index].genPacket();
        if (positive) {
            this.packetPos = packet;
        } else {
            this.packetNeg = packet;
        }
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendIntToClient((byte)index, packet, this.field_174879_c));
        if (!this.beamer[index].getLastSent().isEmpty()) {
            this.prevMag = this.beamer[index].getLastSent();
        }
    }

    @Override
    @Nullable
    public BeamUnit[] getLastSent() {
        return new BeamUnit[]{this.prevMag};
    }

    public int getRedstone() {
        return this.lastRedstone;
    }

    @Override
    public int[] getRenderedBeams() {
        int[] out = new int[6];
        out[Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.getAxis()).func_176745_a()] = this.packetPos;
        out[Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)this.getAxis()).func_176745_a()] = this.packetNeg;
        return out;
    }

    @Override
    public void receiveInt(byte identifier, int message, ServerPlayerEntity player) {
        switch (identifier) {
            case 0: {
                this.packetNeg = message;
                break;
            }
            case 1: {
                this.packetPos = message;
                break;
            }
            case 2: {
                this.contents = message;
                break;
            }
            case 3: {
                this.axis = null;
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("beam_neg", this.packetNeg);
        nbt.func_74768_a("beam_pos", this.packetPos);
        nbt.func_74768_a("contents", this.contents);
        return nbt;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("beam_neg", this.packetNeg);
        nbt.func_74768_a("beam_pos", this.packetPos);
        nbt.func_74768_a("reds", this.lastRedstone);
        nbt.func_74768_a("contents", this.contents);
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.packetPos = nbt.func_74762_e("beam_pos");
        this.packetNeg = nbt.func_74762_e("beam_neg");
        this.lastRedstone = nbt.func_74762_e("reds");
        this.contents = nbt.func_74762_e("contents");
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.magicOpt.invalidate();
        this.magicOptNeg.invalidate();
        this.lensOpt.invalidate();
        if (this.beamer != null && this.field_145850_b != null) {
            for (BeamManager manager : this.beamer) {
                if (manager == null) continue;
                manager.emit(BeamUnit.EMPTY, this.field_145850_b);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.BEAM_CAPABILITY && (side == null || this.getAxis() == side.func_176740_k())) {
            return side == null || side.func_176743_c() == Direction.AxisDirection.POSITIVE ? this.magicOpt : this.magicOptNeg;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lensOpt;
        }
        return super.getCapability(cap, side);
    }

    private class LensHandler
    implements IItemHandler {
        private LensHandler() {
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? LensFrameTileEntity.this.getItem() : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0 || LensFrameTileEntity.this.contents != 0 || !this.isItemValid(0, stack)) {
                return stack;
            }
            if (!simulate) {
                LensFrameTileEntity.this.setContents(LensFrameTileEntity.this.getIDFromItem(stack));
            }
            return stack.func_190916_E() - 1 <= 0 ? ItemStack.field_190927_a : new ItemStack((IItemProvider)stack.func_77973_b(), stack.func_190916_E() - 1);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0 || amount < 1 || LensFrameTileEntity.this.contents == 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack toOutput = LensFrameTileEntity.this.getItem();
            if (!simulate) {
                LensFrameTileEntity.this.setContents(0);
            }
            return toOutput;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : 0;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return LensFrameTileEntity.this.getIDFromItem(stack) != 0;
        }
    }

    private class BeamHandler
    implements IBeamHandler {
        private final Direction.AxisDirection dir;

        private BeamHandler(Direction.AxisDirection dir) {
            this.dir = dir;
        }

        @Override
        public void setBeam(@Nonnull BeamUnit mag) {
            if (LensFrameTileEntity.this.beamer[0] == null || LensFrameTileEntity.this.beamer[1] == null) {
                ((LensFrameTileEntity)LensFrameTileEntity.this).beamer[0] = new BeamManager(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)LensFrameTileEntity.this.getAxis()), LensFrameTileEntity.this.field_174879_c);
                ((LensFrameTileEntity)LensFrameTileEntity.this).beamer[1] = new BeamManager(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)LensFrameTileEntity.this.getAxis()), LensFrameTileEntity.this.field_174879_c);
            }
            switch (LensFrameTileEntity.this.contents) {
                case 0: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(mag, LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                    break;
                }
                case 1: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(new BeamUnit(mag.getEnergy(), 0, 0, 0), LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                    break;
                }
                case 2: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(new BeamUnit(0, mag.getPotential(), 0, 0), LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                    break;
                }
                case 3: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(new BeamUnit(0, 0, mag.getStability(), 0), LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                    break;
                }
                case 4: {
                    if (EnumBeamAlignments.getAlignment(mag) == EnumBeamAlignments.LIGHT) {
                        LensFrameTileEntity.this.setContents(5);
                    }
                }
                case 5: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(mag, LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                    break;
                }
                case 6: {
                    if (!LensFrameTileEntity.this.beamer[this.dir == Direction.AxisDirection.POSITIVE ? 1 : 0].emit(new BeamUnit(0, 0, 0, mag.getPower()), LensFrameTileEntity.this.field_145850_b)) break;
                    LensFrameTileEntity.this.refreshBeam(this.dir == Direction.AxisDirection.POSITIVE);
                }
            }
            LensFrameTileEntity.this.lastRedstone = Math.max(LensFrameTileEntity.this.beamer[0].getLastSent().getPower(), LensFrameTileEntity.this.beamer[1].getLastSent().getPower());
            LensFrameTileEntity.this.func_70296_d();
        }
    }
}

