/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.beams;

import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.BeamUnitStorage;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class QuartzStabilizerTileEntity
extends BeamRenderTE
implements IInfoTE {
    @ObjectHolder(value="quartz_stabilizer")
    private static TileEntityType<QuartzStabilizerTileEntity> type = null;
    private static final int CAPACITY = 1024;
    private static final int[] RATES = new int[]{1, 2, 4, 8, 16, 32, 64};
    private int setting = 0;
    private BeamUnitStorage storage = new BeamUnitStorage();

    public QuartzStabilizerTileEntity() {
        super(type);
    }

    private Direction getDir() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != CRBlocks.quartzStabilizer) {
            return Direction.NORTH;
        }
        return (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
    }

    public int adjustSetting() {
        ++this.setting;
        this.setting %= RATES.length;
        this.func_70296_d();
        return RATES[this.setting];
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("setting", this.setting);
        this.storage.writeToNBT("stab_mag", nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.setting = nbt.func_74762_e("setting");
        this.storage = BeamUnitStorage.readFromNBT("stab_mag", nbt);
    }

    @Override
    protected void doEmit(BeamUnit toEmit) {
        if (toEmit != null) {
            this.storage.addBeam(toEmit);
            if (this.storage.getPower() > 1024) {
                this.storage.subtractBeam(this.storage.getOutput().mult(1.0 - 1024.0 / (double)this.storage.getPower(), false));
            }
        }
        Direction dir = this.getDir();
        if (!this.storage.isEmpty()) {
            int toFill = RATES[this.setting];
            BeamUnit toDraw = new BeamUnit(MiscUtil.withdrawExact(this.storage.getOutput().getValues(), toFill));
            this.storage.subtractBeam(toDraw);
            if (this.beamer[dir.func_176745_a()].emit(toDraw, this.field_145850_b)) {
                this.refreshBeam(dir.func_176745_a());
            }
        } else if (this.beamer[dir.func_176745_a()].emit(BeamUnit.EMPTY, this.field_145850_b)) {
            this.refreshBeam(dir.func_176745_a());
        }
    }

    @Override
    protected boolean[] inputSides() {
        boolean[] out = new boolean[]{true, true, true, true, true, true};
        out[this.getDir().func_176745_a()] = false;
        return out;
    }

    @Override
    protected boolean[] outputSides() {
        boolean[] out = new boolean[6];
        out[this.getDir().func_176745_a()] = true;
        return out;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.quartz_stabilizer.output", new Object[]{RATES[this.setting]}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.quartz_stabilizer.storage", new Object[]{this.storage.getOutput().toString()}));
    }
}

