/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.FatCongealerContainer;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.EdibleBlob;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.tileentities.AbstractShifterTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FatCongealerTileEntity
extends InventoryTE {
    @ObjectHolder(value="fat_congealer")
    private static TileEntityType<FatCongealerTileEntity> type = null;
    public static final double HUN_PER_SPD = 4.0;
    public static final double SAT_PER_SPD = 4.0;
    private Direction facing;
    private LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public FatCongealerTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, true, false, f -> CRFluids.liquidFat.still == f);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Nonnull
    private Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_196959_b((IProperty)ESProperties.HORIZ_FACING)) {
                this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.HORIZ_FACING);
            } else {
                this.func_145843_s();
                return Direction.NORTH;
            }
        }
        return this.facing;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int prevCount = this.inventory[0].func_190916_E();
        this.inventory[0] = AbstractShifterTileEntity.ejectItem((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(this.getFacing()), (Direction)this.getFacing(), (ItemStack)this.inventory[0]);
        if (prevCount != this.inventory[0].func_190916_E()) {
            this.func_70296_d();
        }
        if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
            LazyOptional otherOpt;
            IAxleHandler topHandler = null;
            IAxleHandler bottomHandler = null;
            int hun = 0;
            int sat = 0;
            TileEntity adjTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.UP));
            if (adjTE != null && (otherOpt = adjTE.getCapability(Capabilities.AXLE_CAPABILITY, Direction.DOWN)).isPresent()) {
                topHandler = (IAxleHandler)otherOpt.orElseThrow(NullPointerException::new);
                hun = (int)Math.min(Math.abs(topHandler.getMotionData()[0]) * 4.0, 20.0);
            }
            if ((adjTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.DOWN))) != null && (otherOpt = adjTE.getCapability(Capabilities.AXLE_CAPABILITY, Direction.UP)).isPresent()) {
                bottomHandler = (IAxleHandler)otherOpt.orElseThrow(NullPointerException::new);
                sat = (int)Math.min(Math.abs(bottomHandler.getMotionData()[0]) * 4.0, 20.0);
            }
            if (hun != 0 || sat != 0) {
                int fluidUse = 100 * (hun + sat);
                if (fluidUse > this.fluids[0].getAmount()) {
                    return;
                }
                if (!(this.inventory[0].func_190926_b() || this.inventory[0].func_190916_E() != CRItems.edibleBlob.getItemStackLimit(this.inventory[0]) && EdibleBlob.getHealAmount(this.inventory[0]) == hun && EdibleBlob.getTrueSat(this.inventory[0]) == sat)) {
                    return;
                }
                if (topHandler != null) {
                    topHandler.addEnergy(-hun, false);
                }
                if (bottomHandler != null) {
                    bottomHandler.addEnergy(-sat, false);
                }
                this.fluids[0].shrink(fluidUse);
                if (this.inventory[0].func_190926_b()) {
                    this.inventory[0] = new ItemStack((IItemProvider)CRItems.edibleBlob, 1);
                    this.inventory[0].func_77982_d(EdibleBlob.createNBT(null, hun, sat));
                } else {
                    this.inventory[0].func_190917_f(1);
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.itemOpt.invalidate();
        this.itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != Direction.DOWN && facing != Direction.UP && facing != this.getFacing()) {
            return this.globalFluidOpt;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == null || facing == this.getFacing())) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fat_congealer", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new FatCongealerContainer(id, playerInv, this.createContainerBuf());
    }
}

