/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.gui.container.FluidTankContainer;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FluidTankTileEntity
extends InventoryTE {
    @ObjectHolder(value="fluid_tank")
    private static TileEntityType<FluidTankTileEntity> type = null;
    public static final int CAPACITY = 16000;

    public FluidTankTileEntity() {
        super(type, 0);
        this.fluidProps[0] = new ModuleTE.TankProperty(16000, true, true);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    protected IFluidHandler createGlobalFluidHandler() {
        return new ModuleTE.FluidTankHandler(0);
    }

    public int getRedstone() {
        return RedstoneUtil.clampToVanilla((float)(15.0f * (float)this.fluids[0].getAmount() / 16000.0f));
    }

    public void setContent(FluidStack contentsIn) {
        this.fluids[0] = contentsIn;
        this.func_70296_d();
    }

    public FluidStack getContent() {
        return this.fluids[0];
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.globalFluidOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fluid_tank", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new FluidTankContainer(id, playerInv, this.createContainerBuf());
    }
}

