/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FluidTubeTileEntity
extends TileEntity
implements ITickableTileEntity,
ConduitBlock.IConduitTE<EnumTransferMode> {
    @ObjectHolder(value="fluid_tube")
    private static TileEntityType<FluidTubeTileEntity> type = null;
    protected static final int CAPACITY = 2000;
    private final IFluidHandler mainHandlerIns = new BiFluidHandler();
    private final IFluidHandler inHandlerIns = new InFluidHandler();
    private final IFluidHandler outHandlerIns = new OutFluidHandler();
    private final IFluidHandler innerHandlerIns = new InnerFluidHandler();
    private final NonNullSupplier<IFluidHandler> mainHandler = () -> this.mainHandlerIns;
    private final NonNullSupplier<IFluidHandler> inHandler = () -> this.inHandlerIns;
    private final NonNullSupplier<IFluidHandler> outHandler = () -> this.outHandlerIns;
    private final NonNullSupplier<IFluidHandler> innerHandler = () -> this.innerHandlerIns;
    protected boolean[] matches = new boolean[6];
    protected EnumTransferMode[] modes = ConduitBlock.IConduitTE.genModeArray(EnumTransferMode.INPUT);
    private LazyOptional<IFluidHandler>[] otherOpts = new LazyOptional[]{LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty()};
    private LazyOptional<IFluidHandler>[] internalOpts = new LazyOptional[]{LazyOptional.of(this.mainHandler), LazyOptional.of(this.inHandler), LazyOptional.of(this.outHandler), LazyOptional.of(this.innerHandler)};
    @Nonnull
    private FluidStack content = FluidStack.EMPTY;

    public FluidTubeTileEntity() {
        this(type);
    }

    protected FluidTubeTileEntity(TileEntityType<? extends FluidTubeTileEntity> type) {
        super(type);
    }

    public void func_145836_u() {
        super.func_145836_u();
        for (LazyOptional<IFluidHandler> internalOpt : this.internalOpts) {
            internalOpt.invalidate();
        }
        this.internalOpts[0] = LazyOptional.of(this.mainHandler);
        this.internalOpts[1] = LazyOptional.of(this.inHandler);
        this.internalOpts[2] = LazyOptional.of(this.outHandler);
        this.internalOpts[3] = LazyOptional.of(this.innerHandler);
    }

    public void func_73660_a() {
        int i;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        FluidStack origStack = this.content.copy();
        IFluidHandler[] biHandlers = new IFluidHandler[6];
        int biHandlerCount = 0;
        IFluidHandler[] inHandlers = new IFluidHandler[6];
        int inHandlerCount = 0;
        IFluidHandler[] outHandlers = new IFluidHandler[6];
        int outHandlerCount = 0;
        int totalCapacity = 0;
        int totalFluid = 0;
        int totalInFluid = 0;
        int totalOutFluid = 0;
        FluidStack fluidRef = this.content.copy();
        int LARGE_NUM = 32000;
        BlockState state = this.func_195044_w();
        for (int i2 = 0; i2 < 6; ++i2) {
            boolean hasMatch;
            EnumTransferMode mode = (EnumTransferMode)((Object)state.func_177229_b(CRProperties.CONDUIT_SIDES_FULL[i2]));
            if (!mode.isConnection()) continue;
            IFluidHandler otherHandler = null;
            if (this.otherOpts[i2].isPresent()) {
                otherHandler = (IFluidHandler)this.otherOpts[i2].orElseThrow(NullPointerException::new);
            } else {
                Direction dir = Direction.func_82600_a((int)i2);
                TileEntity otherTe = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
                if (otherTe != null && (this.otherOpts[i2] = otherTe.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, dir.func_176734_d())).isPresent()) {
                    otherHandler = (IFluidHandler)this.otherOpts[i2].orElseThrow(NullPointerException::new);
                }
            }
            boolean bl = hasMatch = otherHandler != null;
            if (hasMatch) {
                switch (mode) {
                    case BOTH: {
                        FluidStack handlerFluid;
                        BiFluidHandler biHandler = null;
                        IFluidTank tankHandler = null;
                        if (otherHandler instanceof BiFluidHandler) {
                            biHandler = (BiFluidHandler)otherHandler;
                        } else if (otherHandler instanceof IFluidTank) {
                            tankHandler = (IFluidTank)otherHandler;
                        } else {
                            mode = EnumTransferMode.NONE;
                            break;
                        }
                        if (biHandler != null && !biHandler.allowExtract()) break;
                        FluidStack fluidStack = handlerFluid = biHandler != null ? biHandler.getFluidInTank(0) : tankHandler.getFluid();
                        if (fluidRef.isEmpty()) {
                            fluidRef = biHandler != null ? otherHandler.getFluidInTank(0).copy() : tankHandler.getFluid().copy();
                        } else if (!handlerFluid.isEmpty() && !BlockUtil.sameFluid((FluidStack)handlerFluid, (FluidStack)fluidRef)) break;
                        biHandlers[biHandlerCount] = otherHandler;
                        ++biHandlerCount;
                        totalFluid += handlerFluid.getAmount();
                        totalCapacity += biHandler != null ? 2000 : tankHandler.getCapacity();
                        break;
                    }
                    case INPUT: {
                        FluidStack drained;
                        if (fluidRef.isEmpty()) {
                            drained = otherHandler.drain(32000, IFluidHandler.FluidAction.SIMULATE);
                            fluidRef = drained.copy();
                        } else {
                            fluidRef.setAmount(32000);
                            drained = otherHandler.drain(fluidRef.copy(), IFluidHandler.FluidAction.SIMULATE);
                        }
                        if (drained.isEmpty()) break;
                        inHandlers[inHandlerCount] = otherHandler;
                        ++inHandlerCount;
                        totalInFluid += drained.getAmount();
                        break;
                    }
                    case OUTPUT: {
                        outHandlers[outHandlerCount] = otherHandler;
                        ++outHandlerCount;
                    }
                }
            }
            this.setData(i2, hasMatch, (Comparable)((Object)mode));
        }
        if (fluidRef.isEmpty()) {
            return;
        }
        int toTestCount = outHandlerCount;
        outHandlerCount = 0;
        int[] passedIndices = new int[6];
        fluidRef.setAmount(32000);
        for (i = 0; i < toTestCount; ++i) {
            int inserted = outHandlers[i].fill(fluidRef.copy(), IFluidHandler.FluidAction.SIMULATE);
            if (inserted <= 0) continue;
            passedIndices[outHandlerCount] = i;
            ++outHandlerCount;
            totalOutFluid += inserted;
        }
        for (i = 0; i < 6; ++i) {
            outHandlers[i] = i < outHandlerCount ? outHandlers[passedIndices[i]] : null;
        }
        int totalSpace = totalOutFluid + 2000 + totalCapacity - totalFluid - this.content.getAmount();
        totalInFluid = Math.min(totalInFluid, totalSpace);
        int drained = 0;
        for (int i3 = 0; i3 < inHandlerCount && drained < totalInFluid; drained += inHandlers[i3].drain(fluidRef.copy(), IFluidHandler.FluidAction.EXECUTE).getAmount(), ++i3) {
            fluidRef.setAmount(totalInFluid - drained);
        }
        int availableFluid = drained + this.content.getAmount() + totalFluid;
        int toFill = Math.min(totalOutFluid, availableFluid);
        int filled = 0;
        for (int i4 = 0; i4 < outHandlerCount && filled < toFill; filled += outHandlers[i4].fill(fluidRef.copy(), IFluidHandler.FluidAction.EXECUTE), ++i4) {
            fluidRef.setAmount(toFill - filled);
        }
        availableFluid -= filled;
        if (biHandlerCount != 0) {
            double pressure = (double)availableFluid / (double)(totalCapacity += 2000);
            availableFluid -= totalFluid;
            for (int i5 = 0; i5 < biHandlerCount; ++i5) {
                FluidStack prev = biHandlers[i5].getFluidInTank(0);
                int capacity = biHandlers[i5].getTankCapacity(0);
                int desired = (int)((double)capacity * pressure);
                if (desired > prev.getAmount()) {
                    fluidRef.setAmount(desired - prev.getAmount());
                    availableFluid -= biHandlers[i5].fill(fluidRef.copy(), IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                if (desired >= prev.getAmount()) continue;
                availableFluid += biHandlers[i5].drain(prev.getAmount() - desired, IFluidHandler.FluidAction.EXECUTE).getAmount();
            }
        }
        FluidStack prevStack = this.content;
        if (availableFluid <= 0 || fluidRef.isEmpty()) {
            this.content = FluidStack.EMPTY;
        } else {
            this.content = fluidRef.copy();
            this.content.setAmount(availableFluid);
        }
        if (!BlockUtil.sameFluid((FluidStack)this.content, (FluidStack)prevStack)) {
            this.func_70296_d();
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        ConduitBlock.IConduitTE.readConduitNBT(nbt, this);
        this.content = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ConduitBlock.IConduitTE.writeConduitNBT(nbt, this);
        if (!this.content.isEmpty()) {
            this.content.writeToNBT(nbt);
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<IFluidHandler> opt : this.internalOpts) {
            opt.invalidate();
        }
        this.internalOpts[0].invalidate();
        this.internalOpts[1].invalidate();
        this.internalOpts[2].invalidate();
        this.internalOpts[3].invalidate();
    }

    protected boolean canConnect(Direction side) {
        return side == null || this.modes[side.func_176745_a()].isConnection();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.internalOpts[3];
            }
            if (this.canConnect(side)) {
                switch (this.modes[side.func_176745_a()]) {
                    case INPUT: {
                        return this.internalOpts[1];
                    }
                    case OUTPUT: {
                        return this.internalOpts[2];
                    }
                    case BOTH: {
                        return this.internalOpts[0];
                    }
                    case NONE: {
                        return LazyOptional.empty();
                    }
                }
            }
        }
        return super.getCapability(capability, side);
    }

    @Override
    @Nonnull
    public boolean[] getHasMatch() {
        return this.matches;
    }

    @Nonnull
    public EnumTransferMode[] getModes() {
        return this.modes;
    }

    @Override
    @Nonnull
    public EnumTransferMode deserialize(String name) {
        return ConduitBlock.IConduitTE.deserializeEnumMode(name);
    }

    @Override
    public boolean hasMatch(int side, EnumTransferMode mode) {
        Direction face = Direction.func_82600_a((int)side);
        TileEntity neighTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        if (neighTE != null) {
            LazyOptional opt = neighTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d());
            return opt.isPresent();
        }
        return false;
    }

    private class InnerFluidHandler
    implements IFluidHandler {
        private InnerFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? FluidTubeTileEntity.this.content : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!FluidTubeTileEntity.this.content.isEmpty() && !BlockUtil.sameFluid((FluidStack)FluidTubeTileEntity.this.content, (FluidStack)resource)) {
                return 0;
            }
            int filled = Math.max(Math.min(resource.getAmount(), 2000 - FluidTubeTileEntity.this.content.getAmount()), 0);
            if (filled != 0 && action.execute()) {
                if (FluidTubeTileEntity.this.content.isEmpty()) {
                    FluidTubeTileEntity.this.content = resource.copy();
                    FluidTubeTileEntity.this.content.setAmount(filled);
                } else {
                    FluidTubeTileEntity.this.content.grow(filled);
                }
                FluidTubeTileEntity.this.func_70296_d();
            }
            return filled;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (FluidTubeTileEntity.this.content.isEmpty() || !BlockUtil.sameFluid((FluidStack)FluidTubeTileEntity.this.content, (FluidStack)resource)) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(resource.getAmount(), FluidTubeTileEntity.this.content.getAmount());
            FluidStack removed = FluidTubeTileEntity.this.content.copy();
            removed.setAmount(drained);
            if (action.execute()) {
                FluidTubeTileEntity.this.content.shrink(drained);
                FluidTubeTileEntity.this.func_70296_d();
            }
            return removed;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (FluidTubeTileEntity.this.content.isEmpty() || maxDrain <= 0) {
                return FluidStack.EMPTY;
            }
            int drained = Math.min(maxDrain, FluidTubeTileEntity.this.content.getAmount());
            FluidStack removed = FluidTubeTileEntity.this.content.copy();
            removed.setAmount(drained);
            if (action.execute()) {
                FluidTubeTileEntity.this.content.shrink(drained);
                FluidTubeTileEntity.this.func_70296_d();
            }
            return removed;
        }
    }

    private class InFluidHandler
    implements IFluidHandler {
        private InFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? FluidTubeTileEntity.this.content : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidTubeTileEntity.this.innerHandlerIns.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }

    private class OutFluidHandler
    implements IFluidHandler {
        private OutFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? FluidTubeTileEntity.this.content : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidTubeTileEntity.this.innerHandlerIns.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidTubeTileEntity.this.innerHandlerIns.drain(maxDrain, action);
        }
    }

    private class BiFluidHandler
    implements IFluidHandler {
        private BiFluidHandler() {
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return tank == 0 ? FluidTubeTileEntity.this.content : FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 2000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidTubeTileEntity.this.innerHandlerIns.fill(resource, action);
        }

        protected boolean allowExtract() {
            if (FluidTubeTileEntity.this.content.isEmpty()) {
                return true;
            }
            for (int i = 0; i < 6; ++i) {
                if (FluidTubeTileEntity.this.modes[i] != EnumTransferMode.OUTPUT || !FluidTubeTileEntity.this.otherOpts[i].isPresent() || ((IFluidHandler)FluidTubeTileEntity.this.otherOpts[i].orElseThrow(NullPointerException::new)).fill(FluidTubeTileEntity.this.content, IFluidHandler.FluidAction.SIMULATE) == 0) continue;
                return false;
            }
            return true;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.allowExtract()) {
                return FluidTubeTileEntity.this.innerHandlerIns.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.allowExtract()) {
                return FluidTubeTileEntity.this.innerHandlerIns.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    }
}

