/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.Crossroads;
import com.Da_Technomancer.crossroads.gui.container.RotaryPumpContainer;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class RotaryPumpTileEntity
extends InventoryTE {
    @ObjectHolder(value="rotary_pump")
    private static TileEntityType<RotaryPumpTileEntity> type = null;
    public static final int INERTIA = 80;
    public static final double MAX_POWER = 5.0;
    private static final int CAPACITY = 4000;
    private static final double REQUIRED = 100.0;
    private double progress = 0.0;
    private int lastProgress = 0;

    public RotaryPumpTileEntity() {
        super(type, 0);
        this.fluidProps[0] = new ModuleTE.TankProperty(4000, false, true);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ModuleTE.AngleAxleHandler();
    }

    @Override
    protected double getMoInertia() {
        return 80.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || 4000 - this.fluids[0].getAmount() < 1000) {
            return;
        }
        IFluidState fstate = this.field_145850_b.func_204610_c(this.field_174879_c.func_177977_b());
        if (fstate.func_206889_d()) {
            double holder = this.motData[1] < 0.0 ? 0.0 : Math.min(Math.min(5.0, this.motData[1]), 100.0 - this.progress);
            this.motData[1] = this.motData[1] - holder;
            this.progress += holder;
            if (this.progress >= 100.0) {
                this.progress = 0.0;
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
                Block block = state.func_177230_c();
                if (block instanceof IBucketPickupHandler) {
                    Fluid fl = ((IBucketPickupHandler)block).func_204508_a((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b(), state);
                    this.fluids[0] = new FluidStack(fl, 1000 + this.fluids[0].getAmount());
                } else {
                    Crossroads.logger.info("Pump attempted to drain a non-traditional fluid at pos: " + this.field_174879_c.func_177977_b().toString());
                }
            }
        } else {
            this.progress = 0.0;
        }
        if (this.lastProgress != (int)this.progress) {
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(1, (long)this.progress, this.field_174879_c));
            this.lastProgress = (int)this.progress;
        }
    }

    public float getCompletion() {
        return (float)this.progress / 100.0f;
    }

    @Override
    public void receiveLong(byte identifier, long message, ServerPlayerEntity player) {
        super.receiveLong(identifier, message, player);
        if (identifier == 1) {
            this.progress = message;
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("prog");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("prog", this.progress);
        return nbt;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != Direction.DOWN && facing != Direction.UP) {
            return this.globalFluidOpt;
        }
        if (capability == Capabilities.AXLE_CAPABILITY && (facing == Direction.UP || facing == null)) {
            return this.axleOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.rotary_pump", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new RotaryPumpContainer(id, playerInv, this.createContainerBuf());
    }
}

