/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.gui.container.FireboxContainer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FireboxTileEntity
extends InventoryTE {
    @ObjectHolder(value="firebox")
    private static TileEntityType<FireboxTileEntity> TYPE = null;
    public static final int POWER = 10;
    private static final int MAX_TEMP = 15000;
    public IntReferenceHolder burnProg = IntReferenceHolder.func_221492_a();
    private int burnTime;
    private int maxBurnTime = 0;
    private LazyOptional<InventoryTE.ItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler(null));

    public FireboxTileEntity() {
        super(TYPE, 1);
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    @Override
    public void func_73660_a() {
        int fuelBurn;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.burnTime != 0) {
            this.temp = Math.min(15000.0, this.temp + 10.0);
            if (--this.burnTime == 0) {
                this.field_145850_b.func_180501_a(this.field_174879_c, CRBlocks.firebox.func_176223_P(), 18);
            }
            this.burnProg.func_221494_a(this.maxBurnTime == 0 ? 0 : 100 * this.burnTime / this.maxBurnTime);
            this.func_70296_d();
        }
        if (this.burnTime == 0 && (fuelBurn = ForgeHooks.getBurnTime((ItemStack)this.inventory[0])) != 0) {
            this.maxBurnTime = this.burnTime = fuelBurn;
            this.burnProg.func_221494_a(100 * this.burnTime / this.maxBurnTime);
            Item item = this.inventory[0].func_77973_b();
            this.inventory[0].func_190918_g(1);
            if (this.inventory[0].func_190926_b() && item.hasContainerItem(this.inventory[0])) {
                this.inventory[0] = item.getContainerItem(this.inventory[0]);
            }
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)CRBlocks.firebox.func_176223_P().func_206870_a((IProperty)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(true)), 18);
            this.func_70296_d();
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.burnTime = nbt.func_74762_e("burn");
        this.maxBurnTime = nbt.func_74762_e("max_burn");
        this.burnProg.func_221494_a(this.maxBurnTime == 0 ? 0 : 100 * this.burnTime / this.maxBurnTime);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("burn", this.burnTime);
        nbt.func_74768_a("max_burn", this.maxBurnTime);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == Capabilities.HEAT_CAPABILITY && (facing == Direction.UP || facing == null)) {
            return this.heatOpt;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && ForgeHooks.getBurnTime((ItemStack)stack) != 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.firebox", new Object[0]);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new FireboxContainer(id, playerInv, this.createContainerBuf());
    }
}

