/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.ICogHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.ILongReceiver;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class LargeGearMasterTileEntity
extends TileEntity
implements ILongReceiver,
ITickableTileEntity,
IInfoTE {
    @ObjectHolder(value="large_gear_master")
    private static TileEntityType<LargeGearMasterTileEntity> teType = null;
    private GearFactory.GearMaterial type;
    private boolean newTE = false;
    private double[] motionData = new double[4];
    private double inertia = 0.0;
    private boolean borken = false;
    private boolean renderOffset = false;
    private float[] angleW = new float[2];
    private Direction facing = null;
    private static final AxisAlignedBB RENDER_BOX = new AxisAlignedBB(-1.0, -1.0, -1.0, 2.0, 2.0, 2.0);
    private final LazyOptional<IAxleHandler> mainOpt = LazyOptional.of(() -> new AxleHandler());

    public LargeGearMasterTileEntity() {
        super(teType);
    }

    public Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != CRBlocks.largeGearMaster) {
                return Direction.NORTH;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        }
        return this.facing;
    }

    public boolean isRenderedOffset() {
        return this.renderOffset;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        RotaryUtil.addRotaryInfo(chat, this.motionData, this.inertia, ((IAxleHandler)this.mainOpt.orElseGet(() -> new AxleHandler())).getRotationRatio(), false);
    }

    public void initSetup(GearFactory.GearMaterial typ) {
        this.type = typ;
        if (!this.field_145850_b.field_72995_K) {
            this.newTE = true;
        }
        this.inertia = this.type == null ? 0.0 : MiscUtil.preciseRound(this.type.getDensity() * 1.125 * 9.0 / 8.0, 2);
    }

    public GearFactory.GearMaterial getMember() {
        return this.type == null ? GearFactory.getDefaultMaterial() : this.type;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_BOX.func_186670_a(this.field_174879_c);
    }

    public void breakGroup(Direction side, boolean drop) {
        if (this.borken) {
            return;
        }
        this.borken = true;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177967_a(side.func_176740_k() == Direction.Axis.X ? Direction.UP : Direction.EAST, i).func_177967_a(side.func_176740_k() == Direction.Axis.Z ? Direction.UP : Direction.NORTH, j), Blocks.field_150350_a.func_176223_P());
            }
        }
        if (drop) {
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CRItems.largeGear.withMaterial(this.type, 1)));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.angleW[0] = (float)((double)this.angleW[0] + (double)this.angleW[1] * 9.0 / Math.PI);
        } else if (this.newTE) {
            this.newTE = false;
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(1, this.type == null ? -1L : (long)this.type.serialize(), this.field_174879_c));
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        for (int j = 0; j < 4; ++j) {
            this.motionData[j] = nbt.func_74769_h("[" + j + "]mot");
        }
        this.type = GearFactory.findMaterial(nbt.func_74779_i("type"));
        this.inertia = this.type == null ? 0.0 : MiscUtil.preciseRound(this.type.getDensity() * 1.125 * 9.0 / 8.0, 3);
        this.angleW[0] = nbt.func_74760_g("angle");
        this.angleW[1] = nbt.func_74760_g("cl_w");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        for (int j = 0; j < 3; ++j) {
            if (this.motionData[j] == 0.0) continue;
            nbt.func_74780_a("[" + j + "]mot", this.motionData[j]);
        }
        if (this.type != null) {
            nbt.func_74778_a("type", this.type.getId());
        }
        nbt.func_74757_a("new", true);
        nbt.func_74776_a("angle", this.angleW[0]);
        nbt.func_74776_a("cl_w", this.angleW[1]);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.type != null) {
            nbt.func_74778_a("type", this.type.getId());
        }
        nbt.func_74757_a("new", true);
        nbt.func_74776_a("angle", this.angleW[0]);
        nbt.func_74776_a("cl_w", this.angleW[1]);
        return nbt;
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 0) {
            float angle = Float.intBitsToFloat((int)(message & 0xFFFFFFFFL));
            this.angleW[0] = Math.abs(angle - this.angleW[0]) > 5.0f ? angle : this.angleW[0];
            this.angleW[1] = Float.intBitsToFloat((int)(message >>> 32));
        } else if (identifier == 1) {
            this.type = GearFactory.GearMaterial.deserialize((int)message);
        } else if (identifier == 2) {
            this.renderOffset = message == 1L;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.mainOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.AXLE_CAPABILITY && (facing == null || facing.func_176740_k() == this.getFacing().func_176740_k())) {
            return this.mainOpt;
        }
        return super.getCapability(capability, facing);
    }

    private class AxleHandler
    implements IAxleHandler {
        private byte updateKey;
        private double rotRatio;
        private IAxisHandler axis;

        private AxleHandler() {
        }

        @Override
        public double[] getMotionData() {
            return LargeGearMasterTileEntity.this.motionData;
        }

        @Override
        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius, boolean renderOffset) {
            if (LargeGearMasterTileEntity.this.type == null) {
                return;
            }
            if (lastRadius != 0.0) {
                rotRatioIn *= lastRadius / 1.5;
            }
            if (key == this.updateKey) {
                if (this.rotRatio != rotRatioIn) {
                    masterIn.lock();
                }
                return;
            }
            if (masterIn.addToList(this)) {
                return;
            }
            this.axis = masterIn;
            this.rotRatio = rotRatioIn;
            LargeGearMasterTileEntity.this.renderOffset = renderOffset;
            this.updateKey = key;
            Direction side = LargeGearMasterTileEntity.this.getFacing();
            for (int i = 0; i < 6; ++i) {
                TileEntity undersideTE;
                LazyOptional cogOpt;
                TileEntity diagTE;
                if (i == side.func_176745_a() || i == side.func_176734_d().func_176745_a()) continue;
                Direction facing = Direction.func_82600_a((int)i);
                TileEntity adjTE = LargeGearMasterTileEntity.this.field_145850_b.func_175625_s(LargeGearMasterTileEntity.this.field_174879_c.func_177967_a(facing, 2));
                if (adjTE != null) {
                    LazyOptional cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, side);
                    if (cogOpt2.isPresent()) {
                        ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, -this.rotRatio, 1.5, facing.func_176734_d(), renderOffset);
                    } else {
                        cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d());
                        if (cogOpt2.isPresent()) {
                            ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, RotaryUtil.getDirSign(side, facing) * this.rotRatio, 1.5, side, renderOffset);
                        }
                    }
                }
                if ((diagTE = LargeGearMasterTileEntity.this.field_145850_b.func_175625_s(LargeGearMasterTileEntity.this.field_174879_c.func_177967_a(facing, 2).func_177972_a(side))) != null && (cogOpt = diagTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d())).isPresent() && RotaryUtil.canConnectThrough(LargeGearMasterTileEntity.this.field_145850_b, LargeGearMasterTileEntity.this.field_174879_c.func_177967_a(facing, 2), facing.func_176734_d(), side)) {
                    ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * this.rotRatio, 1.5, side.func_176734_d(), renderOffset);
                }
                if ((undersideTE = LargeGearMasterTileEntity.this.field_145850_b.func_175625_s(LargeGearMasterTileEntity.this.field_174879_c.func_177967_a(facing, 1).func_177972_a(side))) == null || !(cogOpt = undersideTE.getCapability(Capabilities.COG_CAPABILITY, facing)).isPresent()) continue;
                ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * rotRatioIn, 1.5, side.func_176734_d(), renderOffset);
            }
            for (Direction.AxisDirection dir : Direction.AxisDirection.values()) {
                LazyOptional axleOpt;
                Direction axleDir = dir == Direction.AxisDirection.POSITIVE ? LargeGearMasterTileEntity.this.getFacing() : LargeGearMasterTileEntity.this.getFacing().func_176734_d();
                TileEntity connectTE = LargeGearMasterTileEntity.this.field_145850_b.func_175625_s(LargeGearMasterTileEntity.this.field_174879_c.func_177972_a(axleDir));
                if (connectTE == null) continue;
                LazyOptional axisOpt = connectTE.getCapability(Capabilities.AXIS_CAPABILITY, axleDir.func_176734_d());
                if (axisOpt.isPresent()) {
                    ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
                }
                if (!(axleOpt = connectTE.getCapability(Capabilities.AXLE_CAPABILITY, axleDir.func_176734_d())).isPresent()) continue;
                ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, this.rotRatio, 0.0, renderOffset);
            }
        }

        @Override
        public void disconnect() {
            this.axis = null;
        }

        @Override
        public double getMoInertia() {
            return LargeGearMasterTileEntity.this.inertia;
        }

        @Override
        public float getAngle(float partialTicks) {
            return this.axis == null ? 0.0f : this.axis.getAngle(this.rotRatio, partialTicks, LargeGearMasterTileEntity.this.renderOffset, 7.5f);
        }

        @Override
        public double getRotationRatio() {
            return this.rotRatio;
        }

        @Override
        public void markChanged() {
            LargeGearMasterTileEntity.this.func_70296_d();
        }
    }
}

