/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.ITaylorReceiver;
import com.Da_Technomancer.crossroads.API.packets.SendTaylorToClient;
import com.Da_Technomancer.crossroads.API.rotary.AxisTypes;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class MasterAxisTileEntity
extends TileEntity
implements ITickableTileEntity,
ITaylorReceiver {
    @ObjectHolder(value="master_axis")
    private static TileEntityType<MasterAxisTileEntity> type = null;
    protected static final Random RAND = new Random();
    protected boolean locked = false;
    protected double sumEnergy = 0.0;
    protected long ticksExisted = 0L;
    protected byte key;
    protected int lastKey = 0;
    protected boolean forceUpdate;
    protected Direction facing;
    protected ArrayList<IAxleHandler> rotaryMembers = new ArrayList();
    private long regrTimestamp = 0L;
    private float[] coeff = new float[4];
    private float[] wCoeff = new float[3];
    private float[] prevAngles = new float[4];
    protected static final int UPDATE_TIME = (Integer)CRConfig.gearResetTime.get();
    protected final IAxisHandler handler = new AxisHandler();
    protected LazyOptional<IAxisHandler> axisOpt = LazyOptional.of(() -> this.handler);

    public MasterAxisTileEntity() {
        this(type);
    }

    protected MasterAxisTileEntity(TileEntityType<? extends MasterAxisTileEntity> typeIn) {
        super(typeIn);
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!state.func_196959_b((IProperty)ESProperties.FACING)) {
                this.func_145843_s();
                return Direction.DOWN;
            }
            this.facing = (Direction)state.func_177229_b((IProperty)ESProperties.FACING);
        }
        return this.facing;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.disconnect();
        this.axisOpt.invalidate();
        this.axisOpt = LazyOptional.of(() -> this.handler);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.disconnect();
    }

    public void disconnect() {
        for (IAxleHandler axle : this.rotaryMembers) {
            axle.getMotionData()[0] = 0.0;
            axle.getMotionData()[2] = 0.0;
            axle.getMotionData()[3] = 0.0;
            axle.disconnect();
        }
        for (int i = 0; i < 4; ++i) {
            this.prevAngles[i] = 0.0f;
            this.coeff[i] = 0.0f;
            if (i == 3) continue;
            this.wCoeff[i] = 0.0f;
        }
        this.rotaryMembers.clear();
        RotaryUtil.increaseMasterKey(false);
        this.facing = null;
    }

    protected void runCalc() {
        double sumIRot = 0.0;
        this.sumEnergy = 0.0;
        for (IAxleHandler gear : this.rotaryMembers) {
            sumIRot += gear.getMoInertia() * Math.pow(gear.getRotationRatio(), 2.0);
        }
        if (sumIRot == 0.0 || sumIRot != sumIRot) {
            return;
        }
        this.sumEnergy = RotaryUtil.getTotalEnergy(this.rotaryMembers);
        if (this.sumEnergy < 1.0 && this.sumEnergy > -1.0 || Double.isNaN(this.sumEnergy)) {
            this.sumEnergy = 0.0;
        }
        for (IAxleHandler gear : this.rotaryMembers) {
            double newEnergy;
            double newSpeed;
            gear.getMotionData()[0] = newSpeed = Math.signum(this.sumEnergy * gear.getRotationRatio()) * Math.sqrt(Math.abs(this.sumEnergy) * 2.0 * Math.pow(gear.getRotationRatio(), 2.0) / sumIRot);
            gear.getMotionData()[1] = newEnergy = Math.signum(newSpeed) * Math.pow(newSpeed, 2.0) * gear.getMoInertia() / 2.0;
            gear.getMotionData()[2] = (newEnergy - gear.getMotionData()[3]) * 20.0;
            gear.getMotionData()[3] = newEnergy;
            gear.markChanged();
        }
    }

    protected void runAngleCalc() {
        if (this.rotaryMembers.isEmpty()) {
            for (int i = 0; i < 4; ++i) {
                this.prevAngles[i] = 0.0f;
                this.coeff[i] = 0.0f;
                if (i == 3) continue;
                this.wCoeff[i] = 0.0f;
            }
        } else if (!this.field_145850_b.field_72995_K) {
            boolean signChanged;
            float trueSpeed = (float)(this.rotaryMembers.get(0).getMotionData()[0] / this.rotaryMembers.get(0).getRotationRatio()) / 20.0f;
            if (Float.isNaN(trueSpeed)) {
                trueSpeed = 0.0f;
            }
            System.arraycopy(this.prevAngles, 1, this.prevAngles, 0, 3);
            this.prevAngles[3] = this.prevAngles[2] + trueSpeed;
            if (Float.isNaN(this.prevAngles[3])) {
                this.prevAngles[3] = 0.0f;
            }
            float ADJUST_MARGIN = ((Double)CRConfig.speedPrecision.get()).floatValue() / 20.0f;
            float RESET_MARGIN = ADJUST_MARGIN * 2.0f;
            float speedPred = this.runWSeries(this.ticksExisted);
            float diff = Math.abs(speedPred - trueSpeed);
            if (Float.isNaN(diff)) {
                diff = Float.MAX_VALUE;
            }
            boolean bl = signChanged = Math.signum(speedPred) != Math.signum(trueSpeed);
            if (diff >= ADJUST_MARGIN || signChanged) {
                float delta = this.runSeries(this.ticksExisted, 0.0f) - this.prevAngles[3];
                if (Float.isNaN(delta)) {
                    delta = 0.0f;
                }
                int i = 0;
                while (i < 4) {
                    int n = i++;
                    this.prevAngles[n] = this.prevAngles[n] + delta;
                }
                this.wCoeff[0] = trueSpeed;
                this.wCoeff[1] = 0.0f;
                this.wCoeff[2] = 0.0f;
                this.coeff[0] = trueSpeed;
                this.coeff[1] = 0.0f;
                this.coeff[2] = 0.0f;
                this.coeff[3] = 0.0f;
                this.regrTimestamp = this.ticksExisted;
                float offset = this.runSeries(this.ticksExisted, 0.0f);
                this.coeff[3] = this.prevAngles[3] - offset;
                CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendTaylorToClient(this.ticksExisted, this.coeff, this.field_174879_c));
            }
        }
    }

    private float runSeries(long time, float partialTicks) {
        float relTime = (float)time + partialTicks - (float)this.regrTimestamp;
        return this.coeff[0] * relTime + this.coeff[3];
    }

    private float runWSeries(long time) {
        return this.wCoeff[0];
    }

    @Override
    public void receiveSeries(long timestamp, float[] series) {
        float partTicks = Minecraft.func_71410_x().func_184121_ak();
        float prevAngle = this.runSeries(this.ticksExisted, partTicks);
        this.regrTimestamp = timestamp;
        this.coeff = series;
        this.coeff[3] = this.coeff[3] + (prevAngle - this.runSeries(this.ticksExisted, partTicks));
    }

    public void func_73660_a() {
        ++this.ticksExisted;
        this.func_70296_d();
        if (this.ticksExisted % (long)UPDATE_TIME == 20L || this.forceUpdate || this.rotaryMembers.isEmpty()) {
            this.handler.requestUpdate();
        }
        this.forceUpdate = RotaryUtil.getMasterKey() != this.lastKey;
        this.lastKey = RotaryUtil.getMasterKey();
        if (!this.locked && !this.rotaryMembers.isEmpty()) {
            if (!this.field_145850_b.field_72995_K) {
                this.runCalc();
            }
            this.runAngleCalc();
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.ticksExisted = nbt.func_74763_f("life");
        for (int i = 0; i < 4; ++i) {
            this.prevAngles[i] = nbt.func_74760_g("prev_" + i);
            this.coeff[i] = nbt.func_74760_g("coeff_" + i);
            if (i != 3) {
                this.wCoeff[i] = nbt.func_74760_g("w_coeff_" + i);
            }
            if (!Float.isNaN(this.prevAngles[i])) continue;
            this.prevAngles[i] = 0.0f;
        }
        this.regrTimestamp = nbt.func_74763_f("timestamp");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("life", this.ticksExisted);
        for (int i = 0; i < 4; ++i) {
            nbt.func_74776_a("prev_" + i, this.prevAngles[i]);
            nbt.func_74776_a("coeff_" + i, this.coeff[i]);
            if (i == 3) continue;
            nbt.func_74776_a("w_coeff_" + i, this.wCoeff[i]);
        }
        nbt.func_74772_a("timestamp", this.regrTimestamp);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        return this.func_189515_b(nbt);
    }

    protected AxisTypes getAxisType() {
        return AxisTypes.NORMAL;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.AXIS_CAPABILITY && (side == null || side == this.getFacing())) {
            return this.axisOpt;
        }
        return super.getCapability(cap, side);
    }

    protected class AxisHandler
    implements IAxisHandler {
        private ArrayList<IAxleHandler> memberCopy;

        protected AxisHandler() {
        }

        @Override
        public void trigger(IAxisHandler masterIn, byte keyIn) {
            if (keyIn != MasterAxisTileEntity.this.key) {
                MasterAxisTileEntity.this.locked = true;
            }
        }

        @Override
        public void requestUpdate() {
            LazyOptional axleOpt;
            this.memberCopy = new ArrayList<IAxleHandler>(MasterAxisTileEntity.this.rotaryMembers);
            MasterAxisTileEntity.this.rotaryMembers.clear();
            MasterAxisTileEntity.this.locked = false;
            Direction dir = MasterAxisTileEntity.this.getFacing();
            TileEntity te = MasterAxisTileEntity.this.field_145850_b.func_175625_s(MasterAxisTileEntity.this.field_174879_c.func_177972_a(dir));
            if (te != null && (axleOpt = te.getCapability(Capabilities.AXLE_CAPABILITY, dir.func_176734_d())).isPresent()) {
                byte keyNew;
                while (MasterAxisTileEntity.this.key == (keyNew = (byte)(RAND.nextInt(100) + 1))) {
                }
                MasterAxisTileEntity.this.key = keyNew;
                ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(this, MasterAxisTileEntity.this.key, 1.0, 0.0, false);
            }
            this.memberCopy.removeAll(MasterAxisTileEntity.this.rotaryMembers);
            for (IAxleHandler axle : this.memberCopy) {
                axle.getMotionData()[0] = 0.0;
                axle.disconnect();
            }
            this.memberCopy = null;
        }

        @Override
        public void lock() {
            MasterAxisTileEntity.this.locked = true;
            if (this.memberCopy != null) {
                MasterAxisTileEntity.this.rotaryMembers.addAll(this.memberCopy);
            }
            for (IAxleHandler gear : MasterAxisTileEntity.this.rotaryMembers) {
                gear.getMotionData()[0] = 0.0;
                gear.getMotionData()[1] = 0.0;
                gear.getMotionData()[2] = 0.0;
                gear.getMotionData()[3] = 0.0;
                gear.markChanged();
            }
            for (int i = 0; i < 4; ++i) {
                ((MasterAxisTileEntity)MasterAxisTileEntity.this).prevAngles[i] = 0.0f;
                ((MasterAxisTileEntity)MasterAxisTileEntity.this).coeff[i] = 0.0f;
                if (i == 3) continue;
                ((MasterAxisTileEntity)MasterAxisTileEntity.this).wCoeff[i] = 0.0f;
            }
            MasterAxisTileEntity.this.rotaryMembers.clear();
            if (this.memberCopy != null) {
                this.memberCopy.clear();
            }
        }

        @Override
        public boolean isLocked() {
            return MasterAxisTileEntity.this.locked;
        }

        @Override
        public boolean addToList(IAxleHandler handler) {
            if (!MasterAxisTileEntity.this.locked) {
                MasterAxisTileEntity.this.rotaryMembers.add(handler);
                return false;
            }
            return true;
        }

        @Override
        public double getTotalEnergy() {
            return MasterAxisTileEntity.this.sumEnergy;
        }

        @Override
        public float getAngle(double rotRatio, float partialTicks, boolean shouldOffset, float angleOffset) {
            float angle = MasterAxisTileEntity.this.runSeries(MasterAxisTileEntity.this.ticksExisted, partialTicks);
            angle = (float)((double)angle * rotRatio);
            angle = (float)Math.toDegrees(angle);
            if (shouldOffset) {
                angle += angleOffset;
            }
            return angle;
        }

        @Override
        public AxisTypes getType() {
            return MasterAxisTileEntity.this.getAxisType();
        }
    }
}

