/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.EnergyConverters;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class SteamTurbineTileEntity
extends ModuleTE {
    @ObjectHolder(value="steam_turbine")
    private static TileEntityType<SteamTurbineTileEntity> type = null;
    public static final double INERTIA = 80.0;
    private static final int CAPACITY = 10000;
    public static final int LIMIT = 5;
    private final LazyOptional<IFluidHandler> waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> steamOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public SteamTurbineTileEntity() {
        super(type);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, false, true);
        this.fluidProps[1] = new ModuleTE.TankProperty(10000, true, false, f -> f == CRFluids.steam.still);
    }

    @Override
    protected int fluidTanks() {
        return 2;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected double getMoInertia() {
        return 80.0;
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ModuleTE.AngleAxleHandler();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.fluids[1].isEmpty()) {
            int limit = this.fluids[1].getAmount() / 100;
            limit = Math.min(limit, (10000 - this.fluids[0].getAmount()) / 100);
            if ((limit = Math.min(limit, 5)) != 0) {
                this.fluids[1].shrink(limit * 100);
                if (this.fluids[0].isEmpty()) {
                    this.fluids[0] = new FluidStack((Fluid)CRFluids.distilledWater.still, 100 * limit);
                } else {
                    this.fluids[0].grow(100 * limit);
                }
                if (this.axleHandler.axis != null) {
                    this.axleHandler.addEnergy((double)limit * 0.1 * (double)((Integer)CRConfig.steamWorth.get()).intValue() / EnergyConverters.degPerJoule(), true);
                }
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.waterOpt.invalidate();
        this.steamOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.globalFluidOpt;
            }
            if (facing == Direction.DOWN) {
                return this.steamOpt;
            }
            if (facing != Direction.UP) {
                return this.waterOpt;
            }
        }
        if (capability == Capabilities.AXLE_CAPABILITY && facing == Direction.UP) {
            return this.axleOpt;
        }
        return super.getCapability(capability, facing);
    }
}

