/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class StirlingEngineTileEntity
extends ModuleTE {
    @ObjectHolder(value="stirling_engine")
    private static TileEntityType<StirlingEngineTileEntity> type = null;
    public static final double INERTIA = 200.0;
    public static final double RATE = 5.0;
    private double tempSide;
    private double tempBottom;
    private boolean init = false;
    private final LazyOptional<IHeatHandler> sideHeatOpt = LazyOptional.of(() -> new SideHeatHandler());
    private final LazyOptional<IHeatHandler> bottomHeatOpt = LazyOptional.of(() -> new BottomHeatHandler());

    public StirlingEngineTileEntity() {
        super(type);
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected boolean useHeat() {
        return false;
    }

    @Override
    protected double getMoInertia() {
        return 200.0;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        this.init();
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.stirling_engine.side_temp", new Object[]{CRConfig.formatVal(this.tempSide)}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.stirling_engine.bottom_temp", new Object[]{CRConfig.formatVal(this.tempBottom)}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.temp.biome", new Object[]{CRConfig.formatVal(this.temp)}));
        super.addInfo(chat, player, hit);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.init();
        int level = (int)((this.tempSide - this.tempBottom) / 100.0);
        this.tempSide -= 5.0 * (double)level;
        this.tempBottom += 5.0 * (double)level;
        if (this.axleHandler.axis != null && (double)Math.signum(level) * this.motData[0] < (Double)CRConfig.stirlingSpeedLimit.get()) {
            this.motData[1] = this.motData[1] + (Double)CRConfig.stirlingMultiplier.get() * 5.0 * (double)level * (double)Math.abs(level);
        }
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        nbt.func_74757_a("initHeat", this.init);
        nbt.func_74780_a("temp_side", this.tempSide);
        nbt.func_74780_a("temp_bottom", this.tempBottom);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.init = nbt.func_74767_n("initHeat");
        this.tempSide = nbt.func_74769_h("temp_side");
        this.tempBottom = nbt.func_74769_h("temp_bottom");
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.sideHeatOpt.invalidate();
        this.bottomHeatOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.AXLE_CAPABILITY && (facing == null || facing == Direction.UP)) {
            return this.axleOpt;
        }
        if (capability == Capabilities.HEAT_CAPABILITY && facing != Direction.UP) {
            return facing == Direction.DOWN ? this.bottomHeatOpt : this.sideHeatOpt;
        }
        return super.getCapability(capability, facing);
    }

    private void init() {
        if (!this.init) {
            this.tempBottom = this.tempSide = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
            this.init = true;
        }
    }

    private class BottomHeatHandler
    implements IHeatHandler {
        private BottomHeatHandler() {
        }

        @Override
        public double getTemp() {
            StirlingEngineTileEntity.this.init();
            return StirlingEngineTileEntity.this.tempBottom;
        }

        @Override
        public void setTemp(double tempIn) {
            StirlingEngineTileEntity.this.init();
            StirlingEngineTileEntity.this.tempBottom = tempIn;
        }

        @Override
        public void addHeat(double heat) {
            StirlingEngineTileEntity.this.init();
            StirlingEngineTileEntity.this.tempBottom += heat;
        }
    }

    private class SideHeatHandler
    implements IHeatHandler {
        private SideHeatHandler() {
        }

        @Override
        public double getTemp() {
            StirlingEngineTileEntity.this.init();
            return StirlingEngineTileEntity.this.tempSide;
        }

        @Override
        public void setTemp(double tempIn) {
            StirlingEngineTileEntity.this.init();
            StirlingEngineTileEntity.this.tempSide = tempIn;
        }

        @Override
        public void addHeat(double heat) {
            StirlingEngineTileEntity.this.init();
            StirlingEngineTileEntity.this.tempSide += heat;
        }
    }
}

