/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.ICogHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.IMechanism;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MechanismSmallGear
implements IMechanism {
    protected static final VoxelShape[] SHAPES = new VoxelShape[6];

    @Override
    public double getInertia(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        return MiscUtil.preciseRound(0.125 * mat.getDensity() / 8.0, 3);
    }

    @Override
    public boolean hasCap(Capability<?> cap, Direction capSide, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te) {
        return (cap == Capabilities.COG_CAPABILITY || cap == Capabilities.AXLE_CAPABILITY) && side == capSide;
    }

    @Override
    public void propogate(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te, MechanismTileEntity.SidedAxleHandler handler, IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius) {
        if (side == null) {
            return;
        }
        if (lastRadius != 0.0) {
            rotRatioIn *= lastRadius * 2.0;
        }
        if (key == handler.updateKey) {
            if (handler.rotRatio != rotRatioIn) {
                masterIn.lock();
            }
            return;
        }
        if (masterIn.addToList(handler)) {
            return;
        }
        handler.rotRatio = rotRatioIn;
        handler.updateKey = key;
        for (int i = 0; i < 6; ++i) {
            if (i == side.func_176745_a() || i == side.func_176734_d().func_176745_a() || te.members[i] == null || !te.members[i].hasCap(Capabilities.COG_CAPABILITY, Direction.func_82600_a((int)i), te.mats[i], Direction.func_82600_a((int)i), te.getAxleAxis(), te)) continue;
            te.axleHandlers[i].propogate(masterIn, key, RotaryUtil.getDirSign(side, Direction.func_82600_a((int)i)) * handler.rotRatio, 0.5, !handler.renderOffset);
        }
        TileEntity sideTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(side));
        for (int i = 0; i < 6; ++i) {
            LazyOptional cogOpt;
            TileEntity diagTE;
            if (i == side.func_176745_a() || i == side.func_176734_d().func_176745_a()) continue;
            Direction facing = Direction.func_82600_a((int)i);
            TileEntity adjTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(facing));
            if (adjTE != null) {
                LazyOptional cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, side);
                if (cogOpt2.isPresent()) {
                    ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, -handler.rotRatio, 0.5, facing.func_176734_d(), handler.renderOffset);
                } else {
                    cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d());
                    if (cogOpt2.isPresent()) {
                        ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, RotaryUtil.getDirSign(side, facing) * handler.rotRatio, 0.5, side, handler.renderOffset);
                    }
                }
            }
            if ((diagTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(facing).func_177972_a(side))) != null && (cogOpt = diagTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d())).isPresent() && RotaryUtil.canConnectThrough(te.func_145831_w(), te.func_174877_v().func_177972_a(facing), facing.func_176734_d(), side)) {
                ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * handler.rotRatio, 0.5, side.func_176734_d(), handler.renderOffset);
            }
            if (sideTE == null || !(cogOpt = sideTE.getCapability(Capabilities.COG_CAPABILITY, facing)).isPresent()) continue;
            ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * rotRatioIn, 0.5, side.func_176734_d(), handler.renderOffset);
        }
        if (sideTE != null) {
            LazyOptional axleOpt;
            LazyOptional axisOpt = sideTE.getCapability(Capabilities.AXIS_CAPABILITY, side.func_176734_d());
            if (axisOpt.isPresent()) {
                ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
            }
            if ((axleOpt = sideTE.getCapability(Capabilities.AXLE_CAPABILITY, side.func_176734_d())).isPresent()) {
                ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
            }
        }
        if (te.getAxleAxis() == side.func_176740_k() && te.members[6] != null && te.members[6].hasCap(Capabilities.AXLE_CAPABILITY, side, te.mats[6], null, te.getAxleAxis(), te)) {
            te.axleHandlers[6].propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
        }
    }

    @Override
    @Nonnull
    public ItemStack getDrop(GearFactory.GearMaterial mat) {
        return CRItems.smallGear.withMaterial(mat, 1);
    }

    @Override
    public VoxelShape getBoundingBox(@Nullable Direction side, @Nullable Direction.Axis axis) {
        return side == null ? VoxelShapes.func_197880_a() : SHAPES[side.func_176745_a()];
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(MechanismTileEntity te, float partialTicks, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        if (side == null) {
            return;
        }
        MechanismTileEntity.SidedAxleHandler handler = te.axleHandlers[side.func_176745_a()];
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(side == Direction.DOWN ? 0.0f : (side == Direction.UP ? 180.0f : (side == Direction.NORTH || side == Direction.EAST ? 90.0f : -90.0f))), (float)(side.func_176740_k() == Direction.Axis.Z ? 1.0f : 0.0f), (float)0.0f, (float)(side.func_176740_k() == Direction.Axis.Z ? 0.0f : 1.0f));
        float angle = handler.getAngle(partialTicks);
        GlStateManager.translatef((float)0.0f, (float)-0.4375f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(-side.func_176743_c().func_179524_a()) * angle), (float)0.0f, (float)1.0f, (float)0.0f);
        CRModels.draw8Gear(mat.getColor());
        GlStateManager.popMatrix();
    }

    static {
        MechanismSmallGear.SHAPES[0] = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        MechanismSmallGear.SHAPES[1] = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        MechanismSmallGear.SHAPES[2] = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        MechanismSmallGear.SHAPES[3] = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        MechanismSmallGear.SHAPES[4] = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        MechanismSmallGear.SHAPES[5] = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }
}

