/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.ICogHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.itemSets.GearFactory;
import com.Da_Technomancer.crossroads.render.TESR.CRModels;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismSmallGear;
import com.Da_Technomancer.crossroads.tileentities.rotary.mechanisms.MechanismTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MechanismToggleGear
extends MechanismSmallGear {
    private final boolean inverted;
    private final float sHalf = 7.0f / (16.0f * (1.0f + (float)Math.sqrt(2.0)));
    private final float sHalfT = 0.5f / (1.0f + (float)Math.sqrt(2.0));

    public MechanismToggleGear(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public void onRedstoneChange(double prevValue, double newValue, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, double[] motData, MechanismTileEntity te) {
        if (newValue == 0.0 ^ prevValue == 0.0) {
            te.func_145831_w().func_184133_a(null, te.func_174877_v(), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, newValue != 0.0 ^ this.inverted ? 0.6f : 0.5f);
            RotaryUtil.increaseMasterKey(true);
        }
    }

    @Override
    public boolean hasCap(Capability<?> cap, Direction capSide, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te) {
        return (cap == Capabilities.COG_CAPABILITY && te.redstoneIn != 0 ^ this.inverted || cap == Capabilities.AXLE_CAPABILITY) && side == capSide;
    }

    @Override
    public void propogate(GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis, MechanismTileEntity te, MechanismTileEntity.SidedAxleHandler handler, IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius) {
        if (side == null) {
            return;
        }
        if (lastRadius != 0.0) {
            rotRatioIn *= lastRadius * 2.0;
        }
        if (key == handler.updateKey) {
            if (handler.rotRatio != rotRatioIn) {
                masterIn.lock();
            }
            return;
        }
        if (masterIn.addToList(handler)) {
            return;
        }
        handler.rotRatio = rotRatioIn;
        handler.updateKey = key;
        TileEntity sideTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(side));
        if (te.redstoneIn != 0 ^ this.inverted) {
            int i;
            for (i = 0; i < 6; ++i) {
                if (i == side.func_176745_a() || i == side.func_176734_d().func_176745_a() || te.members[i] == null || !te.members[i].hasCap(Capabilities.COG_CAPABILITY, Direction.func_82600_a((int)i), te.mats[i], Direction.func_82600_a((int)i), te.getAxleAxis(), te)) continue;
                te.axleHandlers[i].propogate(masterIn, key, RotaryUtil.getDirSign(side, Direction.func_82600_a((int)i)) * handler.rotRatio, 0.5, !handler.renderOffset);
            }
            for (i = 0; i < 6; ++i) {
                LazyOptional cogOpt;
                TileEntity diagTE;
                if (i == side.func_176745_a() || i == side.func_176734_d().func_176745_a()) continue;
                Direction facing = Direction.func_82600_a((int)i);
                TileEntity adjTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(facing));
                if (adjTE != null) {
                    LazyOptional cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, side);
                    if (cogOpt2.isPresent()) {
                        ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, -handler.rotRatio, 0.5, facing.func_176734_d(), handler.renderOffset);
                    } else {
                        cogOpt2 = adjTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d());
                        if (cogOpt2.isPresent()) {
                            ((ICogHandler)cogOpt2.orElseThrow(NullPointerException::new)).connect(masterIn, key, RotaryUtil.getDirSign(side, facing) * handler.rotRatio, 0.5, side, handler.renderOffset);
                        }
                    }
                }
                if ((diagTE = te.func_145831_w().func_175625_s(te.func_174877_v().func_177972_a(facing).func_177972_a(side))) != null && (cogOpt = diagTE.getCapability(Capabilities.COG_CAPABILITY, facing.func_176734_d())).isPresent() && RotaryUtil.canConnectThrough(te.func_145831_w(), te.func_174877_v().func_177972_a(facing), facing.func_176734_d(), side)) {
                    ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * handler.rotRatio, 0.5, side.func_176734_d(), handler.renderOffset);
                }
                if (sideTE == null || !(cogOpt = sideTE.getCapability(Capabilities.COG_CAPABILITY, facing)).isPresent()) continue;
                ((ICogHandler)cogOpt.orElseThrow(NullPointerException::new)).connect(masterIn, key, -RotaryUtil.getDirSign(side, facing) * rotRatioIn, 0.5, side.func_176734_d(), handler.renderOffset);
            }
        }
        if (sideTE != null) {
            LazyOptional axleOpt;
            LazyOptional axisOpt = sideTE.getCapability(Capabilities.AXIS_CAPABILITY, side.func_176734_d());
            if (axisOpt.isPresent()) {
                ((IAxisHandler)axisOpt.orElseThrow(NullPointerException::new)).trigger(masterIn, key);
            }
            if ((axleOpt = sideTE.getCapability(Capabilities.AXLE_CAPABILITY, side.func_176734_d())).isPresent()) {
                ((IAxleHandler)axleOpt.orElseThrow(NullPointerException::new)).propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
            }
        }
        if (te.getAxleAxis() == side.func_176740_k() && te.members[6] != null && te.members[6].hasCap(Capabilities.AXLE_CAPABILITY, side, te.mats[6], null, te.getAxleAxis(), te)) {
            te.axleHandlers[6].propogate(masterIn, key, handler.rotRatio, 0.0, handler.renderOffset);
        }
    }

    @Override
    @Nonnull
    public ItemStack getDrop(GearFactory.GearMaterial mat) {
        return this.inverted ? CRItems.invToggleGear.withMaterial(mat, 1) : CRItems.toggleGear.withMaterial(mat, 1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(MechanismTileEntity te, float partialTicks, GearFactory.GearMaterial mat, @Nullable Direction side, @Nullable Direction.Axis axis) {
        if (side == null) {
            return;
        }
        MechanismTileEntity.SidedAxleHandler handler = te.axleHandlers[side.func_176745_a()];
        GlStateManager.pushMatrix();
        GlStateManager.rotatef((float)(side == Direction.DOWN ? 0.0f : (side == Direction.UP ? 180.0f : (side == Direction.NORTH || side == Direction.EAST ? 90.0f : -90.0f))), (float)(side.func_176740_k() == Direction.Axis.Z ? 1.0f : 0.0f), (float)0.0f, (float)(side.func_176740_k() == Direction.Axis.Z ? 0.0f : 1.0f));
        float angle = handler.getAngle(partialTicks);
        GlStateManager.translatef((float)0.0f, (float)-0.4375f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(-side.func_176743_c().func_179524_a()) * angle), (float)0.0f, (float)1.0f, (float)0.0f);
        float top = 0.0625f;
        if (this.inverted) {
            BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(CRModels.TEXTURE_8);
            GlStateManager.color3f((float)1.0f, (float)0.0f, (float)0.0f);
            float radius = 0.125f;
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)(-radius), (double)(top + 0.001f), (double)radius).func_187315_a((double)(0.5f - radius), (double)(0.5f + radius)).func_181675_d();
            vb.func_181662_b((double)radius, (double)(top + 0.001f), (double)radius).func_187315_a((double)(0.5f + radius), (double)(0.5f + radius)).func_181675_d();
            vb.func_181662_b((double)radius, (double)(top + 0.001f), (double)(-radius)).func_187315_a((double)(0.5f + radius), (double)(0.5f - radius)).func_181675_d();
            vb.func_181662_b((double)(-radius), (double)(top + 0.001f), (double)(-radius)).func_187315_a((double)(0.5f - radius), (double)(0.5f - radius)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        if (te.redstoneIn != 0 ^ this.inverted) {
            CRModels.draw8Gear(mat.getColor());
        } else {
            float lHalf = 0.4375f;
            float lHalfT = 0.5f;
            float tHeight = 0.0625f;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(CRModels.TEXTURE_8);
            BufferBuilder vb = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.color3f((float)((float)mat.getColor().getRed() / 255.0f), (float)((float)mat.getColor().getGreen() / 255.0f), (float)((float)mat.getColor().getBlue() / 255.0f));
            vb.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)this.sHalf, (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)(-this.sHalf)).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)this.sHalf).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)top, (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)this.sHalf).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)(-this.sHalf)).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            vb.func_181668_a(9, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)lHalf, (double)(-top), (double)(-this.sHalf)).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)(-top), (double)this.sHalf).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)this.sHalf).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)(-this.sHalf)).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.color3f((float)(((float)mat.getColor().getRed() - 130.0f) / 255.0f), (float)(((float)mat.getColor().getGreen() - 130.0f) / 255.0f), (float)(((float)mat.getColor().getBlue() - 130.0f) / 255.0f));
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b((double)lHalf, (double)(-top), (double)this.sHalf).func_187315_a(1.0, (double)(0.5f + -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)(-top), (double)(-this.sHalf)).func_187315_a(1.0, (double)(0.5f + this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)(-this.sHalf)).func_187315_a((double)(1.0f - tHeight), (double)(0.5f + this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)this.sHalf).func_187315_a((double)(1.0f - tHeight), (double)(0.5f + -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)this.sHalf).func_187315_a((double)tHeight, (double)(0.5f + -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)(-this.sHalf)).func_187315_a((double)tHeight, (double)(0.5f + this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)(-this.sHalf)).func_187315_a(0.0, (double)(0.5f + this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)this.sHalf).func_187315_a(0.0, (double)(0.5f + -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)top, (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), 0.0).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), 0.0).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), (double)tHeight).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), (double)tHeight).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), (double)(1.0f - tHeight)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), (double)(1.0f - tHeight)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), 1.0).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), 1.0).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)(-this.sHalf)).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)(-top), (double)(-this.sHalf)).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)(-this.sHalf)).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)(-this.sHalf)).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - -this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)(-lHalf)).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - -lHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)(-top), (double)this.sHalf).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)lHalf, (double)top, (double)this.sHalf).func_187315_a((double)(0.5f + lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)this.sHalf, (double)top, (double)lHalf).func_187315_a((double)(0.5f + this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)top, (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)top, (double)this.sHalf).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-lHalf), (double)(-top), (double)this.sHalf).func_187315_a((double)(0.5f + -lHalfT), (double)(0.5f - this.sHalfT)).func_181675_d();
            vb.func_181662_b((double)(-this.sHalf), (double)(-top), (double)lHalf).func_187315_a((double)(0.5f + -this.sHalfT), (double)(0.5f - lHalfT)).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
        }
        GlStateManager.popMatrix();
    }
}

