/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class BeaconHarnessTileEntity
extends BeamRenderTE
implements IFluxLink {
    @ObjectHolder(value="beacon_harness")
    private static TileEntityType<BeaconHarnessTileEntity> type = null;
    public static final int FLUX_GEN = 4;
    private static final int LOOP_TIME = 120;
    private static final int SAFETY_BUFFER = 8;
    private static final int POWER = 512;
    private boolean running;
    private int cycles;
    private HashSet<BlockPos> links = new HashSet(1);
    private int flux = 0;
    private int fluxToTrans = 0;

    public BeaconHarnessTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        FluxUtil.addFluxInfo(chat, this, this.running ? 4 : 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long stage = this.field_145850_b.func_82737_E() % 4L;
        if (stage == 0L && this.flux != 0) {
            this.fluxToTrans += this.flux;
            this.flux = 0;
            this.func_70296_d();
        } else if (stage == 1L) {
            this.flux += FluxUtil.performTransfer(this, this.links, this.fluxToTrans);
            this.fluxToTrans = 0;
            FluxUtil.checkFluxOverload(this);
        }
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.flux, this.fluxToTrans);
    }

    private boolean invalid(Color col, BeamUnit last) {
        if (last.isEmpty() || last.getVoid() != 0 || col.getRed() != 0 && last.getEnergy() != 0 || col.getGreen() != 0 && last.getPotential() != 0 || col.getBlue() != 0 && last.getStability() != 0) {
            return true;
        }
        return this.positionInvalid();
    }

    private boolean positionInvalid() {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        for (int y = 0; y < 5; ++y) {
            checkPos.func_189536_c(Direction.UP);
            BlockState state = this.field_145850_b.func_180495_p((BlockPos)checkPos);
            if (state.func_177230_c() == Blocks.field_150461_bJ) {
                return false;
            }
            if (state.isBeaconBase((IWorldReader)this.field_145850_b, (BlockPos)checkPos, (BlockPos)checkPos)) continue;
            return true;
        }
        return true;
    }

    public void trigger() {
        if (!this.running && !this.positionInvalid()) {
            this.running = true;
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (BlockPos linked : this.links) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("run", this.running);
        nbt.func_74768_a("cycle", this.cycles);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        for (BlockPos linked : this.links) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.running = nbt.func_74767_n("run");
        this.cycles = nbt.func_74762_e("cycle");
        this.flux = nbt.func_74762_e("flux");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        if (nbt.func_74764_b("link")) {
            this.links.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link")));
        } else {
            this.links.clear();
        }
    }

    @Override
    protected void doEmit(BeamUnit input) {
        if (this.running) {
            ++this.cycles;
            this.cycles %= 120;
            Color outColor = Color.getHSBColor((float)this.cycles / 120.0f, 1.0f, 1.0f);
            if (this.cycles >= 0) {
                if (this.cycles % 40 >= 8 && this.invalid(outColor, input)) {
                    this.running = false;
                    this.cycles = -11;
                    if (this.beamer[0].emit(BeamUnit.EMPTY, this.field_145850_b)) {
                        this.refreshBeam(0);
                    }
                } else {
                    BeamUnit out = new BeamUnit(outColor.getRed(), outColor.getGreen(), outColor.getBlue(), 0);
                    out = out.mult(512.0 / (double)out.getPower(), false);
                    this.beamer[0].emit(out, this.field_145850_b);
                    this.refreshBeam(0);
                    this.prevMag[0] = out;
                    this.addFlux(4);
                    this.func_70296_d();
                }
            }
        }
    }

    @Override
    protected boolean[] inputSides() {
        return new boolean[]{false, false, true, true, true, true};
    }

    @Override
    protected boolean[] outputSides() {
        return new boolean[]{true, false, false, false, false, false};
    }

    public Set<BlockPos> getLinks() {
        return this.links;
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        if (this.flux != newFlux) {
            this.flux = newFlux;
            this.func_70296_d();
        }
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity serverPlayerEntity) {
        if (identifier == 8) {
            this.links.add(BlockPos.func_218283_e((long)message));
            this.func_70296_d();
        } else if (identifier == 9) {
            this.links.clear();
            this.func_70296_d();
        }
    }
}

