/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ChronoHarnessTileEntity
extends TileEntity
implements IFluxLink,
ITickableTileEntity {
    @ObjectHolder(value="chrono_harness")
    private static TileEntityType<ChronoHarnessTileEntity> type = null;
    private static final int FE_CAPACITY = 20000;
    private static final float SPEED = 3.926991E-4f;
    private int flux = 0;
    private int fluxToTrans = 0;
    private int fe = 20000;
    private int curPower = 0;
    private int clientCurPower = 0;
    private float angle = 0.0f;
    private final HashSet<BlockPos> link = new HashSet(1);
    private final LazyOptional<IEnergyStorage> energyOpt = LazyOptional.of(() -> new EnergyHandler());

    public ChronoHarnessTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.chrono_harness.fe", new Object[]{this.fe, 20000, this.curPower}));
        FluxUtil.addFluxInfo(chat, this, this.shouldRun() ? this.curPower / (Integer)CRConfig.fePerEntropy.get() : 0);
        FluxUtil.addLinkInfo(chat, this);
    }

    public float getRenderAngle(float partialTicks) {
        return (float)Math.toDegrees(this.angle + partialTicks * (float)this.clientCurPower * 3.926991E-4f);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange());
    }

    private boolean hasRedstone() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == CRBlocks.chronoHarness) {
            return (Boolean)state.func_177229_b((IProperty)ESProperties.REDSTONE_BOOL);
        }
        this.func_145843_s();
        return true;
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 4) {
            this.clientCurPower = (int)message;
        }
        if (identifier == 8) {
            this.link.add(BlockPos.func_218283_e((long)message));
            this.func_70296_d();
        } else if (identifier == 9) {
            this.link.clear();
            this.func_70296_d();
        }
    }

    private boolean shouldRun() {
        return this.fe < 20000 && !this.hasRedstone();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.angle += (float)this.clientCurPower * 3.926991E-4f;
        } else {
            long stage = this.field_145850_b.func_82737_E() % 4L;
            if (stage == 0L && this.flux != 0) {
                this.fluxToTrans += this.flux;
                this.flux = 0;
                this.func_70296_d();
            } else if (stage == 1L) {
                this.flux += FluxUtil.performTransfer(this, this.link, this.fluxToTrans);
                this.fluxToTrans = 0;
                FluxUtil.checkFluxOverload(this);
            }
            if (this.shouldRun()) {
                this.curPower = 20000 - this.fe;
                this.fe += this.curPower;
                this.flux += Math.round((float)this.curPower / (float)((Integer)CRConfig.fePerEntropy.get()).intValue());
                this.func_70296_d();
                FluxUtil.checkFluxOverload(this);
            }
            if (this.curPower == 0 ^ this.clientCurPower == 0 || Math.abs(this.curPower - this.clientCurPower) >= 10) {
                this.clientCurPower = this.curPower;
                CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(4, (long)this.clientCurPower, this.field_174879_c));
            }
            if (this.fe != 0) {
                IEnergyStorage storage;
                LazyOptional otherOpt;
                TileEntity neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.UP));
                if (neighbor != null && (otherOpt = neighbor.getCapability(CapabilityEnergy.ENERGY, Direction.DOWN)).isPresent() && (storage = (IEnergyStorage)otherOpt.orElseThrow(NullPointerException::new)).canReceive()) {
                    this.fe -= storage.receiveEnergy(this.fe, false);
                    this.func_70296_d();
                }
                if ((neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(Direction.DOWN))) != null && (otherOpt = neighbor.getCapability(CapabilityEnergy.ENERGY, Direction.UP)).isPresent() && (storage = (IEnergyStorage)otherOpt.orElseThrow(NullPointerException::new)).canReceive()) {
                    this.fe -= storage.receiveEnergy(this.fe, false);
                    this.func_70296_d();
                }
            }
        }
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.flux, this.fluxToTrans);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.energyOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyOpt;
        }
        return super.getCapability(cap, side);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fe", this.fe);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        nbt.func_74768_a("pow", this.curPower);
        for (BlockPos linked : this.link) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.fe = nbt.func_74762_e("fe");
        this.flux = nbt.func_74762_e("flux");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        this.clientCurPower = this.curPower = nbt.func_74762_e("pow");
        if (nbt.func_74764_b("link")) {
            this.link.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link")));
        } else {
            this.link.clear();
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("pow", this.curPower);
        for (BlockPos linked : this.link) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        this.flux = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return this.link;
    }

    private class EnergyHandler
    implements IEnergyStorage {
        private EnergyHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(maxExtract, ChronoHarnessTileEntity.this.fe);
            if (!simulate && extracted > 0) {
                ChronoHarnessTileEntity.this.fe -= extracted;
                ChronoHarnessTileEntity.this.func_70296_d();
            }
            return extracted;
        }

        public int getEnergyStored() {
            return ChronoHarnessTileEntity.this.fe;
        }

        public int getMaxEnergyStored() {
            return 20000;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }
}

