/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FluxSinkTileEntity
extends TileEntity
implements IFluxLink,
ITickableTileEntity {
    @ObjectHolder(value="flux_sink")
    private static TileEntityType<FluxSinkTileEntity> type = null;
    private static final int CAPACITY = 10000;
    private int flux = 0;
    private int prevFlux = 0;
    private boolean running = false;
    private long runningStartTime;

    public FluxSinkTileEntity() {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.flux_sink.desc", new Object[0]));
        FluxUtil.addFluxInfo(chat, this, -1);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 4L == 0L) {
            this.prevFlux = this.flux;
            if (this.isRunning() && this.flux != 0) {
                this.flux = 0;
                this.func_70296_d();
            }
        }
    }

    public double getRunDuration(float partialTicks) {
        return this.running ? (double)((float)(this.field_145850_b.func_82737_E() - this.runningStartTime) + partialTicks) : -1.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-3, -3, -3), this.field_174879_c.func_177982_a(4, 4, 4));
    }

    private boolean isRunning() {
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            boolean prevRunning = this.running;
            this.running = false;
            BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos(this.field_174879_c);
            do {
                mutPos.func_189536_c(Direction.DOWN);
                BlockState state = this.field_145850_b.func_180495_p((BlockPos)mutPos);
                if (state.func_177230_c() == Blocks.field_150461_bJ) {
                    this.running = true;
                    continue;
                }
                if (FluxSinkTileEntity.canBeaconBeamPass(state, this.field_145850_b, (BlockPos)mutPos)) continue;
                return false;
            } while (!this.running && mutPos.func_177956_o() > 1);
            if (prevRunning != this.running) {
                CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(1, this.running ? this.field_145850_b.func_82737_E() : 0L, this.field_174879_c));
                this.func_70296_d();
            }
        }
        return this.running;
    }

    private static boolean canBeaconBeamPass(BlockState state, World world, BlockPos pos) {
        float[] colMult = state.getBeaconColorMultiplier((IWorldReader)world, pos, pos.func_177977_b());
        return colMult != null || state.func_200016_a((IBlockReader)world, pos) < 15 || state.func_177230_c() == Blocks.field_150357_h;
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 1) {
            this.runningStartTime = message;
            this.running = message != 0L;
        }
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.flux = nbt.func_74762_e("flux");
        this.running = nbt.func_74767_n("running");
        this.runningStartTime = nbt.func_74763_f("run_time");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74757_a("running", this.running);
        nbt.func_74772_a("run_time", this.runningStartTime);
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74757_a("running", this.running);
        nbt.func_74772_a("run_time", this.runningStartTime);
        return nbt;
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        this.flux = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return new HashSet<BlockPos>(0);
    }

    @Override
    public int getMaxFlux() {
        return 10000;
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.flux, this.prevFlux);
    }

    @Override
    public IFluxLink.Behaviour getBehaviour() {
        return IFluxLink.Behaviour.SINK;
    }
}

