/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.CircuitUtil;
import com.Da_Technomancer.crossroads.API.rotary.AxisTypes;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.tileentities.rotary.MasterAxisTileEntity;
import com.Da_Technomancer.essentials.blocks.redstone.IRedstoneHandler;
import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class RedstoneAxisTileEntity
extends MasterAxisTileEntity {
    @ObjectHolder(value="redstone_axis")
    private static TileEntityType<RedstoneAxisTileEntity> type = null;
    public CircuitUtil.CircHandler redsHandler = new CircuitUtil.CircHandler();
    private LazyOptional<IRedstoneHandler> redsOpt = CircuitUtil.makeBaseCircuitOptional(this, this.redsHandler, 0.0f);

    public RedstoneAxisTileEntity() {
        super(type);
    }

    @Override
    protected void runCalc() {
        Direction facing = this.getFacing();
        double baseSpeed = CircuitUtil.combineRedsSources(this.redsHandler);
        double sumIRot = 0.0;
        this.sumEnergy = RotaryUtil.getTotalEnergy(this.rotaryMembers);
        for (IAxleHandler gear : this.rotaryMembers) {
            sumIRot += gear.getMoInertia() * Math.pow(gear.getRotationRatio(), 2.0);
        }
        double cost = sumIRot * Math.pow(baseSpeed, 2.0) / 2.0;
        TileEntity backTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing.func_176734_d()));
        LazyOptional backOpt = backTE == null ? LazyOptional.empty() : backTE.getCapability(Capabilities.AXLE_CAPABILITY, facing);
        IAxleHandler sourceAxle = backOpt.isPresent() ? (IAxleHandler)backOpt.orElseThrow(NullPointerException::new) : null;
        double availableEnergy = Math.abs(this.sumEnergy);
        if (sourceAxle != null) {
            availableEnergy += Math.abs(sourceAxle.getMotionData()[1]);
        }
        if (Double.isNaN(availableEnergy)) {
            availableEnergy = 0.0;
        }
        if (Double.isNaN(cost = Math.min(cost, availableEnergy))) {
            cost = 0.0;
        }
        this.sumEnergy = cost;
        availableEnergy -= cost;
        for (IAxleHandler gear : this.rotaryMembers) {
            double newEnergy;
            double newSpeed = sumIRot <= 0.0 || Double.isNaN(sumIRot) ? baseSpeed * gear.getRotationRatio() : Math.signum(this.sumEnergy * gear.getRotationRatio()) * Math.sqrt(Math.abs(this.sumEnergy) * 2.0 * Math.pow(gear.getRotationRatio(), 2.0) / sumIRot);
            gear.getMotionData()[0] = newSpeed;
            gear.getMotionData()[1] = newEnergy = Math.signum(newSpeed) * Math.pow(newSpeed, 2.0) * gear.getMoInertia() / 2.0;
            gear.getMotionData()[2] = (newEnergy - gear.getMotionData()[3]) * 20.0;
            gear.getMotionData()[3] = newEnergy;
            gear.markChanged();
        }
        if (sourceAxle != null) {
            sourceAxle.getMotionData()[1] = sourceAxle.getMotionData()[1] < 0.0 ? -availableEnergy : availableEnergy;
            sourceAxle.markChanged();
        }
        this.runAngleCalc();
    }

    @Override
    protected AxisTypes getAxisType() {
        return AxisTypes.FIXED;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.redsHandler.write(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.redsHandler.read(nbt);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.redsOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction dir) {
        if (cap == RedstoneUtil.REDSTONE_CAPABILITY) {
            return this.redsOpt;
        }
        return super.getCapability(cap, dir);
    }
}

